﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include <nn/settings/system/settings_Clock.h>
#include <nn/settings/system/settings_SystemApplication.h>

namespace nn { namespace settings { namespace detail {

//!< プライベート設定から初回起動設定を取得します。
::nn::Result GetPrivateSettingsInitialLaunchSettings(
    ::nn::settings::system::InitialLaunchSettings* pOutValue) NN_NOEXCEPT;

//!< プライベート設定の初回起動設定を変更します。
::nn::Result SetPrivateSettingsInitialLaunchSettings(
    const ::nn::settings::system::InitialLaunchSettings& value) NN_NOEXCEPT;

//!< プライベート設定から ExternalSteadyClock のソース ID を取得します。
::nn::Result GetPrivateSettingsExternalSteadyClockSourceId(
    ::nn::settings::system::ClockSourceId* pOutValue) NN_NOEXCEPT;

//!< プライベート設定の ExternalSteadyClock のソース ID を変更します。
::nn::Result SetPrivateSettingsExternalSteadyClockSourceId(
    const ::nn::settings::system::ClockSourceId& value) NN_NOEXCEPT;

//!< プライベート設定からシャットダウン時の RTC 値を取得します。
::nn::Result GetPrivateSettingsShutdownRtcValue(int64_t* pOutValue) NN_NOEXCEPT;

//!< プライベート設定のシャットダウン時の RTC 値を変更します。
::nn::Result SetPrivateSettingsShutdownRtcValue(int64_t pOutValue) NN_NOEXCEPT;

//!< プライベート設定から ExternalSteadyClock の内部オフセットを取得します。
::nn::Result GetPrivateSettingsExternalSteadyClockInternalOffset(
    int64_t* pOutValue) NN_NOEXCEPT;

//!< プライベート設定の ExternalSteadyClock の内部オフセットを変更します。
::nn::Result SetPrivateSettingsExternalSteadyClockInternalOffset(
    int64_t pOutValue) NN_NOEXCEPT;

//!< プライベート設定から 時計補正ツールの実行が必要か否かを取得します。
::nn::Result GetPrivateSettingsRequiresRunRepairTimeReviser(bool* pOutValue) NN_NOEXCEPT;

//!< プライベート設定の 時計補正ツールの実行が必要か否かを変更します。
::nn::Result SetPrivateSettingsRequiresRunRepairTimeReviser(bool pOutValue) NN_NOEXCEPT;

//!< プライベート設定を読み出します。
::nn::Result ReadPrivateSettings(
    uint64_t* pOutCount, char outBuffer[], size_t count) NN_NOEXCEPT;

//!< プライベート設定のインメモリモードを有効にします。（デバッグ用）
::nn::Result EnablePrivateSettingsInMemoryModeForDebug(
    void* buffer, size_t size) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
