﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_OnlineStorage.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_OnlineStorageImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetAccountOnlineStorageSettings(
    int32_t* pOutCount,
    ::nn::settings::system::AccountOnlineStorageSettings outValues[],
    size_t count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::OutArray<::nn::settings::system::AccountOnlineStorageSettings>
        outArray(outValues, count);
    NN_RESULT_DO(pProxy->GetAccountOnlineStorageSettings(pOutCount, outArray));
    NN_RESULT_SUCCESS;
}

::nn::Result SetAccountOnlineStorageSettings(
    const ::nn::settings::system::AccountOnlineStorageSettings* values,
    size_t count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::InArray<::nn::settings::system::AccountOnlineStorageSettings>
        inArray(values, count);
    NN_RESULT_DO(pProxy->SetAccountOnlineStorageSettings(inArray));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
