﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_HidImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetUsbFullKeyEnableFlag(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetUsbFullKeyEnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetUsbFullKeyEnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetUsbFullKeyEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetVibrationMasterVolume(float* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetVibrationMasterVolume(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetVibrationMasterVolume(float value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetVibrationMasterVolume(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetNxControllerSettings(
    int32_t* pOutCount,
    ::nn::settings::system::NxControllerSettings outValues[],
    int count) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::OutArray<::nn::settings::system::NxControllerSettings
                       >outArray(outValues, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->GetNxControllerSettings(pOutCount, outArray));
    NN_RESULT_SUCCESS;
}

::nn::Result SetNxControllerSettings(
    const ::nn::settings::system::NxControllerSettings values[],
    int count) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::InArray<::nn::settings::system::NxControllerSettings
                      > inArray(values, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->SetNxControllerSettings(inArray));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
