﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_FirmwareVersionImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetFirmwareVersion(
    ::nn::settings::system::FirmwareVersion* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetFirmwareVersion2(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetFirmwareVersionDigest(
    ::nn::settings::system::FirmwareVersionDigest* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetFirmwareVersionDigest(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetRebootlessSystemUpdateVersion(
    ::nn::settings::system::RebootlessSystemUpdateVersion* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetRebootlessSystemUpdateVersion(pOutValue));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
