﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>
#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/lmem/lmem_Common.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/settings_ServiceName.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ProxyObjectAllocator.h>

#include "settings_FactorySettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result CreateFactorySettingsServerProxy(
    ::nn::sf::SharedPointer<IFactorySettingsServer>* pOutValue
    ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    NN_FUNCTION_LOCAL_STATIC(
        ::nn::sf::ProxyObjectAllocator<16>, s_Allocator, = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER);

    NN_FUNCTION_LOCAL_STATIC(::std::atomic<bool>, s_IsInitialized, (false));

    if (!s_IsInitialized)
    {
        static ::nn::os::SdkMutexType s_Mutex = NN_OS_SDK_MUTEX_INITIALIZER();

        ::std::lock_guard<decltype(s_Mutex)> locker(s_Mutex);

        if (!s_IsInitialized)
        {
            s_Allocator.Initialize();

            s_IsInitialized = true;
        }
    }

    NN_RESULT_DO(
        (::nn::sf::CreateHipcProxyByName<
             IFactorySettingsServer
             >)(pOutValue, s_Allocator.GetMemoryResource(), FactorySettingsServiceName));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
