﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/factory/settings_DeviceCertificate.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetEciDeviceCertificate(
    ::nn::settings::factory::EccB233DeviceCertificate* pOutValue) NN_NOEXCEPT;

::nn::Result GetEciDeviceCertificate(
    ::nn::settings::factory::Rsa2048DeviceCertificate* pOutValue) NN_NOEXCEPT;

::nn::Result GetEticketDeviceCertificate(
    ::nn::settings::factory::Rsa2048DeviceCertificate* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
