﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_Clock.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetExternalSteadyClockSourceId(
    ::nn::settings::system::ClockSourceId* pOutValue) NN_NOEXCEPT;

::nn::Result SetExternalSteadyClockSourceId(
    const ::nn::settings::system::ClockSourceId& value) NN_NOEXCEPT;

::nn::Result GetShutdownRtcValue(int64_t* pOutValue) NN_NOEXCEPT;

::nn::Result SetShutdownRtcValue(int64_t value) NN_NOEXCEPT;

::nn::Result GetExternalSteadyClockInternalOffset(
    int64_t* pOutValue) NN_NOEXCEPT;

::nn::Result SetExternalSteadyClockInternalOffset(int64_t value) NN_NOEXCEPT;

::nn::Result GetUserSystemClockContext(
    ::nn::settings::system::SystemClockContext* pOutValue) NN_NOEXCEPT;

::nn::Result SetUserSystemClockContext(
    const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT;

::nn::Result GetNetworkSystemClockContext(
    ::nn::settings::system::SystemClockContext* pOutValue) NN_NOEXCEPT;

::nn::Result SetNetworkSystemClockContext(
    const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT;

::nn::Result IsUserSystemClockAutomaticCorrectionEnabled(
    bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetUserSystemClockAutomaticCorrectionEnabled(
    bool value) NN_NOEXCEPT;

::nn::Result GetUserSystemClockAutomaticCorrectionUpdatedTime(
    ::nn::time::SteadyClockTimePoint* pOutValue) NN_NOEXCEPT;

::nn::Result SetUserSystemClockAutomaticCorrectionUpdatedTime(
    const ::nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
