﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Clock.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_ClockImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetExternalSteadyClockSourceId(
    ::nn::settings::system::ClockSourceId* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetExternalSteadyClockSourceId(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetExternalSteadyClockSourceId(
    const ::nn::settings::system::ClockSourceId& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetExternalSteadyClockSourceId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetShutdownRtcValue(int64_t* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetShutdownRtcValue(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetShutdownRtcValue(int64_t value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetShutdownRtcValue(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetExternalSteadyClockInternalOffset(
    int64_t* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetExternalSteadyClockInternalOffset(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetExternalSteadyClockInternalOffset(int64_t value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetExternalSteadyClockInternalOffset(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetUserSystemClockContext(
    ::nn::settings::system::SystemClockContext* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetUserSystemClockContext(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetUserSystemClockContext(
    const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetUserSystemClockContext(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetNetworkSystemClockContext(
    ::nn::settings::system::SystemClockContext* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetNetworkSystemClockContext(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetNetworkSystemClockContext(
    const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetNetworkSystemClockContext(value));
    NN_RESULT_SUCCESS;
}

::nn::Result IsUserSystemClockAutomaticCorrectionEnabled(
    bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(
        pProxy->IsUserSystemClockAutomaticCorrectionEnabled(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetUserSystemClockAutomaticCorrectionEnabled(
    bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetUserSystemClockAutomaticCorrectionEnabled(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetUserSystemClockAutomaticCorrectionUpdatedTime(
    ::nn::time::SteadyClockTimePoint* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(
        pProxy->GetUserSystemClockAutomaticCorrectionUpdatedTime(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetUserSystemClockAutomaticCorrectionUpdatedTime(
    const ::nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetUserSystemClockAutomaticCorrectionUpdatedTime(value));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
