﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_BluetoothDevices.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetBluetoothDevicesSettings(
    int* pOutCount,
    ::nn::settings::system::BluetoothDevicesSettings outValues[],
    int count) NN_NOEXCEPT;

::nn::Result SetBluetoothDevicesSettings(
    const ::nn::settings::system::BluetoothDevicesSettings values[],
    int count) NN_NOEXCEPT;

::nn::Result GetBluetoothEnableFlag(bool *pOutValue) NN_NOEXCEPT;

::nn::Result SetBluetoothEnableFlag(bool value) NN_NOEXCEPT;

::nn::Result GetBluetoothAfhEnableFlag(bool *pOutValue) NN_NOEXCEPT;

::nn::Result SetBluetoothAfhEnableFlag(bool value) NN_NOEXCEPT;

::nn::Result GetBluetoothBoostEnableFlag(bool *pOutValue) NN_NOEXCEPT;

::nn::Result SetBluetoothBoostEnableFlag(bool value) NN_NOEXCEPT;

::nn::Result GetBlePairingSettings(
    int* pOutCount,
    ::nn::settings::system::BlePairingSettings outValues[],
    int count) NN_NOEXCEPT;

::nn::Result SetBlePairingSettings(
    const ::nn::settings::system::BlePairingSettings values[],
    int count) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
