﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_Audio.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetAudioVolume(
    ::nn::settings::system::AudioVolume* pOutValue, int32_t index) NN_NOEXCEPT;

::nn::Result SetAudioVolume(
    const ::nn::settings::system::AudioVolume& value, int32_t index
    ) NN_NOEXCEPT;

::nn::Result GetAudioOutputMode(int32_t* pOutValue, int32_t index) NN_NOEXCEPT;

::nn::Result SetAudioOutputMode(int32_t value, int32_t index) NN_NOEXCEPT;

::nn::Result IsForceMuteOnHeadphoneRemoved(bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetForceMuteOnHeadphoneRemoved(bool forceMute) NN_NOEXCEPT;

::nn::Result GetHeadphoneVolumeWarningCount(int32_t* pOutValue) NN_NOEXCEPT;

::nn::Result SetHeadphoneVolumeWarningCount(int32_t value) NN_NOEXCEPT;

::nn::Result GetHeadphoneVolumeUpdateFlag(bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetHeadphoneVolumeUpdateFlag(bool value) NN_NOEXCEPT;

::nn::Result NeedsToUpdateHeadphoneVolume(
    bool* pOutValue, bool* pOutIsHighPowerAvailable, int8_t* pOutVolume,
    bool isRestricted) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
