﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include <nn/util/util_Uuid.h>
#include <nn/settings/system/settings_ServiceDiscovery.h>

namespace nn { namespace settings { namespace detail {

//!< アプリケーション設定から Mii 作者 ID を取得します。
::nn::Result GetApplicationSettingsMiiAuthorId(
    ::nn::util::Uuid* pOutValue) NN_NOEXCEPT;

//!< アプリケーション設定からサービスディスカバリの制御設定を取得します。
::nn::Result GetApplicationSettingsServiceDiscoveryControlSettings(
    ::nn::settings::system::ServiceDiscoveryControlSettings* pOutValue) NN_NOEXCEPT;

//!< アプリケーション設定のサービスディスカバリの制御設定を変更します。
::nn::Result SetApplicationSettingsServiceDiscoveryControlSettings(
    const ::nn::settings::system::ServiceDiscoveryControlSettings& value) NN_NOEXCEPT;

//!< アプリケーション設定から修理中か否かを表す値を取得します。
::nn::Result GetApplicationSettingsInRepairProcessFlag(bool* pOutValue) NN_NOEXCEPT;

//!< アプリケーション設定の修理中か否かを表す値を変更します。
::nn::Result SetApplicationSettingsInRepairProcessFlag(bool value) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
