﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/sasbus/driver/sasbus.h>

namespace nn {
namespace sasbus {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

void OpenSession(Session* pOutSession, SasbusDevice device) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(device);
}

void CloseSession(Session* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

nn::Result Send(Session* pSession, const void* pInData, size_t dataBytes, const char reg) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(pInData);
    NN_UNUSED(dataBytes);
    NN_UNUSED(reg);
    return nn::ResultSuccess();
}

nn::Result Receive(void* pOutData, Session* pSession, size_t dataBytes, const char reg) NN_NOEXCEPT
{
    NN_UNUSED(pOutData);
    NN_UNUSED(pSession);
    NN_UNUSED(dataBytes);
    NN_UNUSED(reg);
    return nn::ResultSuccess();
}

Result StartPeriodicReceiveMode(Session* pSession, size_t dataSize, char reg, nn::TimeSpan interval, char* receiveBuffer, size_t receiveBufferLength) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(dataSize);
    NN_UNUSED(reg);
    NN_UNUSED(interval);
    NN_UNUSED(receiveBuffer);
    NN_UNUSED(receiveBufferLength);
    return nn::ResultSuccess();
}

void StopPeriodicReceiveMode(Session* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void Suspend()
{
}

void Resume()
{
}

} // driver
} // sasbus
} // nn
