﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

// nn.TimeSpanType を使えるようにする
namespace nn {
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpanType
    {
    }
}

namespace nn.pwm
{

    // 実操作を担当する PWM のセッションオブジェクト。
    // セッションの取得は Manager で行う。
    [CppRefPath("<nn/pwm/pwm_IChannelSession.sfdl.h>")]
    interface IChannelSession : IServiceObject
    {
        [MethodId(0)]
        Result SetPeriod(nn.TimeSpanType period);

        [MethodId(1)]
        Result GetPeriod(Out<nn.TimeSpanType> period);

        [MethodId(2)]
        Result SetDuty(int duty);

        [MethodId(3)]
        Result GetDuty(Out<int> duty);

        [MethodId(4)]
        Result SetEnabled(bool enable);

        [MethodId(5)]
        Result GetEnabled(Out<bool> enable);
    }

    // チャンネルごとの PWM セッションを返すマネージャークラス
    [CppRefPath("<nn/pwm/pwm_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenSessionForDev(Out<IChannelSession> outSession, int32_t channel);

        [MethodId(1)]
        Result OpenSession(Out<IChannelSession> outSession, int32_t channel);
    }
}
