﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dd.h>
#include <nn/os.h>
#include <nn/util/util_BitPack.h>

#include "pwm_ChannelSessionImpl-soc.tegra-x1.h"
#include "pwm_DriverImplInterface.h"

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

// PMC モジュールの物理アドレス (TRM 2.1)
const nn::dd::PhysicalAddress PmcPhysicalAddress = 0x7000e400ull;

// PMC モジュールにある LED 制御関連レジスタのアドレス (TRM 11.6)
const size_t PmcCntrlPhysicalAddress = PmcPhysicalAddress + 0x00;
const size_t PmcDpdPadsOridePhysicalAddress = PmcPhysicalAddress + 0x1c;
const size_t PmcBlinkTimerPhysicalAddress = PmcPhysicalAddress + 0x40;

// LED 制御関連のレジスタ定義 (必要なビットのみ)
struct PmcRegister
{
    // APBDEV_PMC_CNTRL_0 (TRM 11.6.1)
    typedef nn::util::BitPack32::Field<  7,  1, int  > Cntrl_BlinkEn;           // Enable blinking counter and blink output

    // APBDEV_PMC_DPD_PADS_ORIDE_0 (TRM 11.6.8)
    typedef nn::util::BitPack32::Field< 20,  1, int  > DpdPadsOride_Blink;      // Override DPD idle state with blink output

    // APBDEV_PMC_BLINK_TIMER_0 (TRM 11.6.17)
    typedef nn::util::BitPack32::Field< 16, 16, int  > BlinkTimer_DataOff;     // Time off
    typedef nn::util::BitPack32::Field< 15,  1, bool > BlinkTimer_ForceBlink;  // set to 0 for 32kHz clock
    typedef nn::util::BitPack32::Field<  0, 15, int  > BlinkTimer_DataOn;      // Time on
};

class DriverImplBlinkLed : public DriverImplInterface
{
public:
    virtual void Open(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void Close(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void SetPeriod(ChannelSessionImpl& session, nn::TimeSpan period) NN_NOEXCEPT;
    virtual nn::TimeSpan GetPeriod(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void SetDuty(ChannelSessionImpl& session, int duty) NN_NOEXCEPT;
    virtual int GetDuty(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void SetEnabled(ChannelSessionImpl& session, bool enable) NN_NOEXCEPT;
    virtual bool GetEnabled(ChannelSessionImpl& session) NN_NOEXCEPT;

private:
    const int MaxDuty = 100;

private:
    nn::TimeSpan m_Period;
    int m_Duty;
    bool m_Enabled;

    bool m_PreviousDpdPadsOrideBlink;

    bool m_Initialized = false;

private:
    void UpdateRegister();
};

} // detail
} // driver
} // pwm
} // nn
