﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pwm/detail/pwm_Log.h>

#include <nne/pwm/pwm.h>

#include "pwm_DriverImpl-soc.tegra-x1.h"

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

void DriverImpl::Open(ChannelSessionImpl& session) NN_NOEXCEPT
{
    nne::pwm::Open(session.channelIndex);
}

void DriverImpl::Close(ChannelSessionImpl& session) NN_NOEXCEPT
{
    nne::pwm::Close(session.channelIndex);
}

void DriverImpl::SetPeriod(ChannelSessionImpl& session, nn::TimeSpan period) NN_NOEXCEPT
{
    CheckIsSuspended(session);

    nne::pwm::Result result = nne::pwm::SetConfig(session.channelIndex, static_cast<uint8_t>(session.duty), period);
    NN_SDK_ASSERT(result == nne::pwm::Result_Success);
    NN_UNUSED(result); // Release ビルドの warning 対策
}

nn::TimeSpan DriverImpl::GetPeriod(ChannelSessionImpl& session) NN_NOEXCEPT
{
    CheckIsSuspended(session);

    uint8_t duty;
    nn::TimeSpan period;
    nne::pwm::GetConfig(&duty, &period, session.channelIndex);
    return period;
}

void DriverImpl::SetDuty(ChannelSessionImpl& session, int duty) NN_NOEXCEPT
{
    CheckIsSuspended(session);

    nne::pwm::Result result = nne::pwm::SetConfig(session.channelIndex, static_cast<uint8_t>(duty), session.period);
    NN_SDK_ASSERT(result == nne::pwm::Result_Success);
    NN_UNUSED(result); // Release ビルドの warning 対策
}

int DriverImpl::GetDuty(ChannelSessionImpl& session) NN_NOEXCEPT
{
    CheckIsSuspended(session);

    uint8_t duty;
    nn::TimeSpan period;
    nne::pwm::GetConfig(&duty, &period, session.channelIndex);

    return duty;
}

void DriverImpl::SetEnabled(ChannelSessionImpl& session, bool enable) NN_NOEXCEPT
{
    CheckIsSuspended(session);

    nne::pwm::SetEnabled(session.channelIndex, enable);
}

bool DriverImpl::GetEnabled(ChannelSessionImpl& session) NN_NOEXCEPT
{
    CheckIsSuspended(session);

    return nne::pwm::GetEnabled(session.channelIndex);
}

void DriverImpl::Initialize() NN_NOEXCEPT
{
    nne::pwm::Initialize();
}

void DriverImpl::Finalize() NN_NOEXCEPT
{
    nne::pwm::Finalize();
}

void DriverImpl::SuspendAllChannels() NN_NOEXCEPT
{
    if (!m_IsSuspended)
    {
        m_IsSuspended = true;
        nne::pwm::SuspendChannel();
    }
}

void DriverImpl::ResumeAllChannels() NN_NOEXCEPT
{
    if(m_IsSuspended)
    {
        nne::pwm::ResumeChannel();
        m_IsSuspended = false;
    }
}

} // detail
} // driver
} // pwm
} // nn
