﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_TypedStorage.h>

#include <nn/pwm/driver/pwm_Channel.h>
#include <nne/pwm/pwm_Lib.h>

#include "pwm_DriverImplInterface.h"

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

/**
 * @brief   チャンネルセッションの実データ構造体
 */
struct ChannelSessionImpl
{
    bool                    isOpen;
    nne::pwm::PwmChannelId  channelIndex;
    bool                    isEnabled;
    nn::TimeSpan            period;
    int                     duty;
    DriverImplInterface*    pDriverImpl;
};

struct ChannelSessionImplPadded
{
    ChannelSessionImpl  impl;

    // ChannelSession 型の TypedStorage とサイズを合わせるための微調整部分
    char                _padding[ChannelSessionSize - sizeof(ChannelSessionImpl)];
};

NN_FORCEINLINE
ChannelSessionImpl& ToChannelSessionImpl(ChannelSession& session)
{
    return nn::util::Get<ChannelSessionImplPadded>(session._impl).impl;
}

NN_FORCEINLINE
const ChannelSessionImpl& ToChannelSessionImpl(const ChannelSession& session)
{
    return nn::util::Get<ChannelSessionImplPadded>(session._impl).impl;
}

} // detail
} // driver
} // pwm
} // nn
