﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Spec により ChannelName の列挙子定義が異なる
#include <nn/pwm/pwm_ChannelName.h>

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

// 各チャンネルに対応するデバイス名
// ChannelName_Invalid はデバイス名ではアクセスできず、ForDev API でのみアクセス可
const ChannelName ChannelNameMap[] =
{
    // PWM0
    ChannelName::ChannelName_Invalid,

    // PWM1
    ChannelName::ChannelName_Invalid,

    // PWM2
    ChannelName::ChannelName_Invalid,

    // PWM3
    // note: 使うには、GPIO_PE7 の pinmux を PM3_PWM3 に切り替えておく必要がある
    ChannelName::ChannelName_CpuFan,
};

} // detail
} // driver
} // channel
} // nn
