﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.psm
{
    [ExternalStruct(64, 4)]
    [CppRefPath("<nn/psm/psm_ErrorReportTypes.h>")]
    public struct BatteryChargeInfoFields
    {
    }

    [CppRefPath("<nn/psm/psm_IPsmSession.sfdl.h>")]
    interface IPsmSession : IServiceObject
    {
        [MethodId(0)]
        Result BindStateChangeEvent(Out<NativeHandle> outHandle);

        [MethodId(1)]
        Result UnbindStateChangeEvent();

        [MethodId(2)]
        Result SetChargerTypeChangeEventEnabled(bool isEnabled);

        [MethodId(3)]
        Result SetPowerSupplyChangeEventEnabled(bool isEnabled);

        [MethodId(4)]
        Result SetBatteryVoltageStateChangeEventEnabled(bool isEnabled);
    }

    [CppRefPath("<nn/psm/psm_IPsmServer.sfdl.h>")]
    interface IPsmServer : IServiceObject
    {
        [MethodId(0)]
        Result GetBatteryChargePercentage(Out<int_t> batteryCharge);

        [MethodId(1)]
        Result GetChargerType(Out<int_t> chargerType);

        [MethodId(2)]
        Result EnableBatteryCharging();

        [MethodId(3)]
        Result DisableBatteryCharging();

        [MethodId(4)]
        Result IsBatteryChargingEnabled(Out<bool> isEnabled);

        [MethodId(5)]
        Result AcquireControllerPowerSupply();

        [MethodId(6)]
        Result ReleaseControllerPowerSupply();

        [MethodId(7)]
        Result OpenSession(Out<IPsmSession> outSession);

        [MethodId(8)]
        Result EnableEnoughPowerChargeEmulation();

        [MethodId(9)]
        Result DisableEnoughPowerChargeEmulation();

        [MethodId(10)]
        Result EnableFastBatteryCharging();

        [MethodId(11)]
        Result DisableFastBatteryCharging();

        [MethodId(12)]
        Result GetBatteryVoltageState(Out<int_t> outBatteryVoltageState);

        [MethodId(13)]
        Result GetRawBatteryChargePercentage(Out<double> rawBatteryCharge);

        [MethodId(14)]
        Result IsEnoughPowerSupplied(Out<bool> isEnoughPowerSupplied);

        [MethodId(15)]
        Result GetBatteryAgePercentage(Out<double> batteryAge);

        [MethodId(16)]
        Result GetBatteryChargeInfoEvent(Out<NativeHandle> outHandle);

        [MethodId(17)]
        Result GetBatteryChargeInfoFields(Out<BatteryChargeInfoFields> outBatteryChargeInfoFields);

        [MethodId(18)]
        Result GetBatteryChargeCalibratedEvent(Out<NativeHandle> outHandle);
    }
}
