﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/psm/psm_SystemTypes.h>

#include "psm_BatteryState.h"
#include "psm_ChargeArbiter.h"
#include "psm_IChargerDriver.h"
#include "psm_ErrorReporter.h"
#include "psm_OverlayNotificationSender.h"
#include "psm_SessionManager.h"
#include "psm_SettingsHolder-spec.nx.h"
#include "psm_SupplyRouteManager.h"
#include "psm_UsbPowerManagerStub.h"

namespace nn { namespace psm { namespace driver { namespace detail {

UsbPowerManagerStub::UsbPowerManagerStub() NN_NOEXCEPT
    : m_PowerEvent()
    , m_PowerDeliveryNoticeEvent()
    , m_EnoughPowerChargeEmulationEvent()
{
    // 何もしません。
}

UsbPowerManagerStub::~UsbPowerManagerStub() NN_NOEXCEPT
{
    // 何もしません。
}

void UsbPowerManagerStub::Initialize(
    ChargeArbiter* pChargeArbiter,
    SupplyRouteManager* pSupplyRouteManager,
    BatteryState* pBatteryState,
    IChargerDriver* pChargerDriver,
    SessionManager* pSessionManager,
    OverlayNotificationSender* pNotificationSender,
    const SettingsHolder* pSettingsHolder) NN_NOEXCEPT
{
    NN_UNUSED(pChargeArbiter);
    NN_UNUSED(pSupplyRouteManager);
    NN_UNUSED(pChargerDriver);
    NN_UNUSED(pSessionManager);
    NN_UNUSED(pNotificationSender);
    NN_UNUSED(pSettingsHolder);

    ::nn::os::CreateSystemEvent(&m_PowerEvent, ::nn::os::EventClearMode_ManualClear, false);
    ::nn::os::CreateSystemEvent(&m_PowerDeliveryNoticeEvent, ::nn::os::EventClearMode_ManualClear, false);
    ::nn::os::CreateSystemEvent(&m_EnoughPowerChargeEmulationEvent, ::nn::os::EventClearMode_ManualClear, false);

    // SIGLO-61924: USB で給電能力を特定しない場合、EnoughPowerSupply 状態にします。
    // USB 以外の給電能力の特定方法が実装されたときに本処理は修正します。
    pBatteryState->SetChargerType(ChargerType_EnoughPower);
    pBatteryState->SetEnoughPowerSupplied(true);
}

void UsbPowerManagerStub::Finalize() NN_NOEXCEPT
{
    ::nn::os::DestroySystemEvent(&m_EnoughPowerChargeEmulationEvent);
    ::nn::os::DestroySystemEvent(&m_PowerDeliveryNoticeEvent);
    ::nn::os::DestroySystemEvent(&m_PowerEvent);
}

::nn::Result UsbPowerManagerStub::AllowOtg() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result UsbPowerManagerStub::DisallowOtg() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result UsbPowerManagerStub::EnableEnoughPowerChargeEmulation() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result UsbPowerManagerStub::DisableEnoughPowerChargeEmulation() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::os::SystemEventType* UsbPowerManagerStub::GetPowerEvent() NN_NOEXCEPT
{
    return &m_PowerEvent;
}

::nn::os::SystemEventType* UsbPowerManagerStub::GetPowerDeliveryNoticeEvent() NN_NOEXCEPT
{
    return &m_PowerDeliveryNoticeEvent;
}

::nn::os::SystemEventType* UsbPowerManagerStub::GetEnoughPowerChargeEmulationEvent() NN_NOEXCEPT
{
    return &m_EnoughPowerChargeEmulationEvent;
}

::nn::Result UsbPowerManagerStub::Update() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result UsbPowerManagerStub::ProcessPowerDeliveryNoticeEvent() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result UsbPowerManagerStub::ProcessEnoughPowerChargeEmulationEvent() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

}}}} // namespace nn::psm::driver::detail
