﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "psm_IFuelGaugeDriver.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class IFuelGaugeParameterManager
{
public:
    IFuelGaugeParameterManager() NN_NOEXCEPT {}

    virtual ~IFuelGaugeParameterManager() NN_NOEXCEPT {}

    virtual ::nn::Result Initialize(IFuelGaugeDriver* pFuelGaugeDriver) NN_NOEXCEPT = 0;

    virtual ::nn::Result SaveParameter() NN_NOEXCEPT = 0;

    virtual ::nn::Result RestoreParameter() NN_NOEXCEPT = 0;

    virtual ::nn::Result FlushParameter() NN_NOEXCEPT = 0;
};

}}}} // namespace nn::psm::driver::detail
