﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/psm/psm_System.h>
#include <nn/psm/psm_SystemProcess.h>

namespace nn { namespace psm { namespace driver { namespace detail {

class IBatteryState
{
    NN_DISALLOW_COPY(IBatteryState);
    NN_DISALLOW_MOVE(IBatteryState);

public:
    IBatteryState() NN_NOEXCEPT
    {
        // 何もしない
    }

    virtual ~IBatteryState() NN_NOEXCEPT
    {
        // 何もしない
    }

    //! 電池残量を取得します。
    virtual int GetBatteryChargePercentage() NN_NOEXCEPT = 0;

    //! 未加工の電池残量を取得します。
    virtual double GetRawBatteryChargePercentage() NN_NOEXCEPT = 0;

    //! 電池劣化量を取得します。
    virtual double GetBatteryAgePercentage() NN_NOEXCEPT = 0;

    //! 本体に接続された充電器の種別を取得します。
    virtual ChargerType GetChargerType() NN_NOEXCEPT = 0;

    //! 未加工の電池電圧を取得します。
    virtual int GetRawBatteryChargeMilliVoltage() NN_NOEXCEPT = 0;

    //! 電池電圧状態を取得します。
    virtual BatteryVoltageState GetBatteryVoltageState() NN_NOEXCEPT = 0;

    //! 十分な給電がされているかどうかを取得します。
    virtual bool IsEnoughPowerSupplied() NN_NOEXCEPT = 0;
};

}}}} // namespace nn::psm::driver::detail
