﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include "psm_ErrorReporter.h"

#include "psm_FuelGaugeDriverStub.h"

namespace nn { namespace psm { namespace driver { namespace detail {

void FuelGaugeDriverStub::Initialize() NN_NOEXCEPT
{
    ::nn::os::CreateSystemEvent(&m_DummyInterruptEvent, ::nn::os::EventClearMode_ManualClear, true);
}

void FuelGaugeDriverStub::Finalize() NN_NOEXCEPT
{
    ::nn::os::DestroySystemEvent(&m_DummyInterruptEvent);
}

::nn::Result FuelGaugeDriverStub::EnableInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::DisableInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetLowTemperatureThreshold(int thresholdCelsius) NN_NOEXCEPT
{
    NN_UNUSED(thresholdCelsius);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetHighTemperatureThreshold(int thresholdCelsius) NN_NOEXCEPT
{
    NN_UNUSED(thresholdCelsius);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetLowVoltageThreshold(int thresholdMillivolt) NN_NOEXCEPT
{
    NN_UNUSED(thresholdMillivolt);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetHighVoltageThreshold(int thresholdMillivolt) NN_NOEXCEPT
{
    NN_UNUSED(thresholdMillivolt);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetLowChargeThreshold(int thresholdPercentage) NN_NOEXCEPT
{
    NN_UNUSED(thresholdPercentage);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetHighChargeThreshold(int thresholdPercentage) NN_NOEXCEPT
{
    NN_UNUSED(thresholdPercentage);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::DisableLowChargeInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::DisableHighChargeInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::BindInterrupt(::nn::os::SystemEventType* pOutInterruptEvent) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutInterruptEvent);
    auto handle = ::nn::os::GetReadableHandleOfSystemEvent(&m_DummyInterruptEvent);
    ::nn::os::AttachReadableHandleToSystemEvent(pOutInterruptEvent, handle, false, ::nn::os::EventClearMode_ManualClear);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::ClearInterrupt(::nn::os::SystemEventType* pInterruptEvent) NN_NOEXCEPT
{
    NN_UNUSED(pInterruptEvent);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::ClearTemperatureInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::ClearVoltageInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::ClearChargeInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::ClearBatteryInterrupt() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetTemperatureCelsius(double* pTemperature) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pTemperature);
    *pTemperature = 25.0; // Ambient
    GetErrorReporter().SetBatteryTemperature(*pTemperature);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetMaxTemperatureCelsius(int* pOutMaxTemperatureCelsius) NN_NOEXCEPT
{
    NN_UNUSED(pOutMaxTemperatureCelsius);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetStatus(Status* pStatus) NN_NOEXCEPT
{
    NN_UNUSED(pStatus);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetBatteryChargePercentage(double* pOutValue) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutValue);
    *pOutValue = 100.0;
    GetErrorReporter().SetBatteryChargePercent(*pOutValue);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetBatteryChargeMilliVoltage(int* pOutValue) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutValue);
    *pOutValue = 4100; // NX の高温充電許可スレッショルド 4050 mV よりも高い値
    GetErrorReporter().SetBatteryChargeVoltage(static_cast<int>(*pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetBatteryAgePercentage(double* pOutValue) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutValue);
    *pOutValue = 100.0;
    GetErrorReporter().SetBatteryAge(*pOutValue);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SaveParameter(Parameter* pOutParameter) NN_NOEXCEPT
{
    NN_UNUSED(pOutParameter);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::RestoreParameter(const Parameter& parameter) NN_NOEXCEPT
{
    NN_UNUSED(parameter);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::SetNeedToRestoreParameters(bool needToRestoreParameters) NN_NOEXCEPT
{
    NN_UNUSED(needToRestoreParameters);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetNeedToRestoreParameters(bool* pNeedToRestoreParameters) NN_NOEXCEPT
{
    NN_UNUSED(pNeedToRestoreParameters);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetCycles(int* pOutCycles) NN_NOEXCEPT
{
    NN_UNUSED(pOutCycles);
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::ClearCycles() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetAverageCurrentMilliAmpere(int* pOutValue) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutValue);
    *pOutValue = 0;
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetVoltageFuelGaugePercentage(double* pOutPercentage) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutPercentage);
    *pOutPercentage = 100.0;
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetFullCapacityMilliAmpereH(int* pOutMilliAmpereH) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutMilliAmpereH);
    *pOutMilliAmpereH = 4667;
    NN_RESULT_SUCCESS;
}

::nn::Result FuelGaugeDriverStub::GetRemainingCapacityMilliAmpereH(int* pOutMilliAmpereH) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutMilliAmpereH);
    *pOutMilliAmpereH = 4667;
    NN_RESULT_SUCCESS;
}

}}}} // namespace nn::psm::driver::detail
