﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/psm/detail/psm_Log.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace psm { namespace driver { namespace detail {

class FirmwareDebugSettingsAccessor {

public:
    //! Firmware Debug Settings を読む。
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pName, const char* pSettingsName) NN_NOEXCEPT
    {
        size_t targetSize = ::nn::settings::fwdbg::GetSettingsItemValueSize(pSettingsName, pName);
        if ( 0 == targetSize )
        {
            NN_DETAIL_PSM_WARN("Failed to read %s.%s (Value is not written)\n", pSettingsName, pName);
            return;
        }
        else if ( sizeof(T) != targetSize )
        {
            NN_DETAIL_PSM_WARN("Failed to read %s.%s (data size does not match). expected=%d, actual=%d\n", pSettingsName, pName, sizeof(T), targetSize);
            return;
        }

        T temporaryValue;
        if ( sizeof(T) != (::nn::settings::fwdbg::GetSettingsItemValue(&temporaryValue, sizeof(T), pSettingsName, pName)) )
        {
            NN_DETAIL_PSM_WARN("Failed to read %s.%s.\n", pSettingsName, pName);
        }
        else
        {
            *pOutValue = temporaryValue;
        }
    }

    //! SettingsName 省略時は psm のパラメータを見に行く
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pName) NN_NOEXCEPT
    {
        ReadSetting(pOutValue, pName, "psm");
    }
};

}}}} // namespace nn::psm::driver::detail
