﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>

#include "psm_ChargerDriverStub.h"
#include "psm_ErrorReporter.h"

namespace nn { namespace psm { namespace driver { namespace detail {

ChargerDriverStub::ChargerDriverStub() NN_NOEXCEPT
{
    // 何もしません。
}

ChargerDriverStub::~ChargerDriverStub() NN_NOEXCEPT
{
    // 何もしません。
}

void ChargerDriverStub::Initialize() NN_NOEXCEPT
{
    ::nn::os::CreateSystemEvent(&m_DummyInterruptEvent, ::nn::os::EventClearMode_ManualClear, true);

    // ErrorReporter 初期値設定
    GetErrorReporter().SetInputCurrentLimit(500);
    GetErrorReporter().SetBoostModeCurrentLimit(500);
    GetErrorReporter().SetHizMode(false);
    GetErrorReporter().SetChargeConfiguration(0);
}

void ChargerDriverStub::Finalize() NN_NOEXCEPT
{
    ::nn::os::DestroySystemEvent(&m_DummyInterruptEvent);
}

::nn::Result ChargerDriverStub::EnableOnTheGo() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::EnableBatteryCharging() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::EnterHiZMode() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::ExitHiZMode() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetInputVoltageLimitMilliVolt(int inputVoltageLimitMilliVolt) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER_EQUAL(inputVoltageLimitMilliVolt, 0);
    NN_UNUSED(inputVoltageLimitMilliVolt);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetInputCurrentLimit(int limitMilliAmpere) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER_EQUAL(limitMilliAmpere, 0);
    NN_UNUSED(limitMilliAmpere);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetFastChargeCurrentLimit(int limitMilliAmpere) NN_NOEXCEPT
{
    return SetFastChargeCurrentLimit(limitMilliAmpere, FastChargeCurrentLimitOption::None);
}

::nn::Result ChargerDriverStub::SetFastChargeCurrentLimit(int limitMilliAmpere, FastChargeCurrentLimitOption fastChargeCurrentLimitOption) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER_EQUAL(limitMilliAmpere, 0);
    NN_UNUSED(limitMilliAmpere);
    NN_UNUSED(fastChargeCurrentLimitOption);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetBoostModeCurrentLimit(int limitMilliAmpere) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER_EQUAL(limitMilliAmpere, 0);
    NN_UNUSED(limitMilliAmpere);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::GetStatus(Status* pStatus) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pStatus);
    *pStatus = Status::NotCharging;
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetChargeVoltageLimit(int limitMilliVolt) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER_EQUAL(limitMilliVolt, 0);
    NN_UNUSED(limitMilliVolt);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::GetFaultStatus(FaultStatus* pFaultStatus) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pFaultStatus);
    pFaultStatus->Clear();
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetWatchdogTimerPeriod(::nn::TimeSpan period) NN_NOEXCEPT
{
    NN_UNUSED(period);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::EnableWatchdogTimer() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::DisableWatchdogTimer() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::ResetWatchdogTimer() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

bool ChargerDriverStub::IsWatchdogTimerEnabled() NN_NOEXCEPT
{
    return false;
}

::nn::Result ChargerDriverStub::BindInterrupt(::nn::os::SystemEventType* pOutInterruptEvent) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutInterruptEvent);
    auto handle = ::nn::os::GetReadableHandleOfSystemEvent(&m_DummyInterruptEvent);
    ::nn::os::AttachReadableHandleToSystemEvent(pOutInterruptEvent, handle, false, ::nn::os::EventClearMode_ManualClear);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::ClearInterrupt(::nn::os::SystemEventType* pInterruptEvent) NN_NOEXCEPT
{
    NN_UNUSED(pInterruptEvent);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetChargeEnable(bool enabled) NN_NOEXCEPT
{
    NN_UNUSED(enabled);
    NN_RESULT_SUCCESS;
}

::nn::Result ChargerDriverStub::SetEnoughPowerChargeEmulation(bool enabled) NN_NOEXCEPT
{
    NN_UNUSED(enabled);
    NN_RESULT_SUCCESS;
}

}}}} // namespace nn::psm::driver::detail
