﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include "psm_BatteryTemperatureLevel.h"
#include "psm_ChargeArbiter.h"
#include "psm_IFuelGaugeDriver.h"
#include "psm_FuelGaugeDriver.h" // TODO: IFuelGaugeDriver経由で閾値を取得するべきです。

namespace nn { namespace psm { namespace driver { namespace detail {

class BatteryTemperatureManager final
{
    NN_DISALLOW_COPY(BatteryTemperatureManager);
    NN_DISALLOW_MOVE(BatteryTemperatureManager);

public:
    BatteryTemperatureManager() NN_NOEXCEPT
    {
        // 何もしない
    }

    //! 初期化します。
    ::nn::Result Initialize(
        IFuelGaugeDriver* pFuelGaugeDriver,
        ChargeArbiter* pChargeArbiter) NN_NOEXCEPT;

    //! 終了処理をします。
    void Finalize() NN_NOEXCEPT;

    //! 温度管理を更新します。
    ::nn::Result Update() NN_NOEXCEPT;

private:
    BatteryTemperatureLevel QuantizeTemperature(double celsius) NN_NOEXCEPT;

    int GetLowTemperatureThresholdCelsius(BatteryTemperatureLevel level) NN_NOEXCEPT;

    int GetHighTemperatureThresholdCelsius(BatteryTemperatureLevel level) NN_NOEXCEPT;

    ::nn::Result UpdateInternal() NN_NOEXCEPT;

private:
    //! 電池残量計ドライバ
    IFuelGaugeDriver* m_pFuelGaugeDriver;

    //! 充電調停用アービタ
    ChargeArbiter* m_pChargeArbiter;

    //! 電池温度レベル
    BatteryTemperatureLevel m_TemperatureLevel;
};

}}}} // namespace nn::psm::driver::detail
