﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../psm_IUsbPowerManager.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

//! NX における USB の電力関連イベントの処理を行うクラス
class UsbPowerEventHandler final : public EventHandler
{
    NN_DISALLOW_COPY(UsbPowerEventHandler);
    NN_DISALLOW_MOVE(UsbPowerEventHandler);

public:
    UsbPowerEventHandler() NN_NOEXCEPT;

    virtual ~UsbPowerEventHandler() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(IUsbPowerManager* pUsbPowerManager) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! テスト用途で USB PM のハンドリング完了イベントへのポインタを返します。
    ::nn::Result GetUsbPmEventForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT;

    //! テスト用途で給電エミュレーションのハンドリング完了イベントへのポインタを返します。
    ::nn::Result GetEnoughPowerChargeEmulationEventForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT;

private:
    ::nn::Result ProcessUsbPmEvent() NN_NOEXCEPT;

    ::nn::Result ProcessEnoughPowerChargeEmulationEvent() NN_NOEXCEPT;

private:
    //! USB の電源関連のマネージャー
    IUsbPowerManager* m_pUsbPowerManager;

    //! USB::PM の割り込みを検出するイベント
    ::nn::os::MultiWaitHolderType m_UpmMultiWaitHolder;

    //! 給電エミュレーションの設定変更を受信するイベント
    ::nn::os::MultiWaitHolderType m_EnoughPowerChargeEmulationMultiWaitHolder;

    //! テスト用途の USB PM のハンドリング完了イベント
    ::nn::os::EventType m_UsbPmEvent;

    //! テスト用途の給電エミュレーションのハンドリング完了イベント
    ::nn::os::EventType m_EnoughPowerChargeEmulationEventForTest;
};

}}}} // namespace nn::psm::driver::detail
