﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/gpio/gpio.h>
#include <nn/psc/psc_PmModule.h>

#include "../psm_SettingsHolder-spec.nx.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class SystemPowerStateEventHandlerLow final : public EventHandler
{
    NN_DISALLOW_COPY(SystemPowerStateEventHandlerLow);
    NN_DISALLOW_MOVE(SystemPowerStateEventHandlerLow);

public:
    SystemPowerStateEventHandlerLow() NN_NOEXCEPT;

    virtual ~SystemPowerStateEventHandlerLow() NN_NOEXCEPT NN_OVERRIDE;

    //! 初期化します。
    ::nn::Result Initialize(const SettingsHolder* pSettingsHolder) NN_NOEXCEPT;

    //! 終了処理をします。
    void Finalize() NN_NOEXCEPT;

    //! 多重待ちオブジェクトヘッダにイベントをリンクします。
    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    //! 多重待ちオブジェクトヘッダからイベントをアンリンクします。
    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    //! イベントがシグナル状態であれば処理を行います。
    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

private:
    //! システム電源状態遷移に対応した処理を行います。
    void HandlePowerStateEvent(::nn::psc::PmState pmState, ::nn::psc::PmFlagSet pmFlagSet) NN_NOEXCEPT;

    //! USB Type-C Power Source の回路バージョンを取得します。
    int GetUsbTypeCPowerSourceCircuitVersion() NN_NOEXCEPT;

    //! GPIO セッションを初期化します。
    void InitializeVdd5v3EnAndVconnEn() NN_NOEXCEPT;

    //! GPIO セッションを終了します。
    void FinalizeVdd5v3EnAndVconnEn() NN_NOEXCEPT;

    //! 電源投入状態にします。
    void PowerOnVdd5v3EnAndVconnEn() NN_NOEXCEPT;

    //! 電源遮断状態にします。
    void PowerOffVdd5v3EnAndVconnEn() NN_NOEXCEPT;

private:
    //! システム電源状態管理モジュール
    ::nn::psc::PmModule m_PmModule;

    //! システム電源状態遷移通知の MultiWaitHolder
    ::nn::os::MultiWaitHolderType m_PmModuleMultiWaitHolder;

    //! USB Type-C Power Source 回路バージョンを取得するための SettingsHolder へのポインタ
    const SettingsHolder* m_pSettingsHolder;

    //! VDD5V3 の DCDC を制御するためのセッション
    ::nn::gpio::GpioPadSession m_Vdd5v3EnSession;

    //! VCONN 端子への 5V を供給を制御するためのセッション
    ::nn::gpio::GpioPadSession m_VConnEnSession;
};

}}}} // namespace nn::psm::driver::detail
