﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/psc/psc_PmModule.h>

#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

// 循環参照解決用の宣言
class PowerStateManager;

class SystemPowerStateEventHandler final : public EventHandler
{
    NN_DISALLOW_COPY(SystemPowerStateEventHandler);
    NN_DISALLOW_MOVE(SystemPowerStateEventHandler);

public:
    SystemPowerStateEventHandler() NN_NOEXCEPT;

    virtual ~SystemPowerStateEventHandler() NN_NOEXCEPT NN_OVERRIDE;

    //! 初期化します。
    ::nn::Result Initialize(PowerStateManager* pPowerStateManager) NN_NOEXCEPT;

    //! 終了処理をします。
    void Finalize() NN_NOEXCEPT;

    //! 多重待ちオブジェクトヘッダにイベントをリンクします。
    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    //! 多重待ちオブジェクトヘッダからイベントをアンリンクします。
    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    //! イベントがシグナル状態であれば処理を行います。
    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! テスト用途で m_PmModule へのポインタを返します。
    ::nn::Result GetPmModuleForTest(::nn::psc::PmModule** pOutPmModulePointer) NN_NOEXCEPT;

    //! テスト用途で PSC のハンドリング完了イベントへのポインタを返します。
    ::nn::Result GetPscEventForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT;

private:
    //! 電源管理モジュール
    ::nn::psc::PmModule m_PmModule;

    //! PSC からの通知イベントの多重待ちオブジェクトホルダー
    ::nn::os::MultiWaitHolderType m_PmModuleMultiWaitHolder;

    //! システム電源状態マネージャ
    PowerStateManager* m_pPowerStateManager;

    //! テスト用途の PSC のハンドリング完了イベント
    ::nn::os::EventType m_PscEvent;
};

}}}} // namespace nn::psm::driver::detail
