﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>

#include "../psm_IFuelGaugeParameterManager.h"
#include "psm_PeriodicCustomParameterSaver.h"

namespace nn { namespace psm { namespace driver { namespace detail {

namespace {

const ::nn::TimeSpan CustomParameterSaveInterval = ::nn::TimeSpan::FromHours(12);

} // namespace

PeriodicCustomParameterSaver::PeriodicCustomParameterSaver() NN_NOEXCEPT
    : m_pFuelGaugeParameterManager()
    , m_PeriodicCustomParameterSaveEvent()
    , m_PeriodicCustomParameterSaveMultiWaitHolder()
{
    // 何もしない。
}

PeriodicCustomParameterSaver::~PeriodicCustomParameterSaver() NN_NOEXCEPT
{
    // 何もしない。
}

void PeriodicCustomParameterSaver::Initialize(IFuelGaugeParameterManager* pFuelGaugeParameterManager) NN_NOEXCEPT
{
    m_pFuelGaugeParameterManager = pFuelGaugeParameterManager;

    ::nn::os::InitializeTimerEvent(&m_PeriodicCustomParameterSaveEvent, ::nn::os::EventClearMode_ManualClear);
    ::nn::os::InitializeMultiWaitHolder(&m_PeriodicCustomParameterSaveMultiWaitHolder, &m_PeriodicCustomParameterSaveEvent);
}

void PeriodicCustomParameterSaver::Finalize() NN_NOEXCEPT
{
    ::nn::os::FinalizeMultiWaitHolder(&m_PeriodicCustomParameterSaveMultiWaitHolder);
    ::nn::os::FinalizeTimerEvent(&m_PeriodicCustomParameterSaveEvent);
}

void PeriodicCustomParameterSaver::LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT
{
    ::nn::os::LinkMultiWaitHolder(pMultiWait, &m_PeriodicCustomParameterSaveMultiWaitHolder);
}

void PeriodicCustomParameterSaver::UnlinkMultiWaitHolders() NN_NOEXCEPT
{
    ::nn::os::UnlinkMultiWaitHolder(&m_PeriodicCustomParameterSaveMultiWaitHolder);
}

void PeriodicCustomParameterSaver::StartPeriodicTimerEvent() NN_NOEXCEPT
{
    ::nn::os::StartPeriodicTimerEvent(&m_PeriodicCustomParameterSaveEvent, CustomParameterSaveInterval, CustomParameterSaveInterval);
}

void PeriodicCustomParameterSaver::StopTimerEvent() NN_NOEXCEPT
{
    ::nn::os::StopTimerEvent(&m_PeriodicCustomParameterSaveEvent);
}

bool PeriodicCustomParameterSaver::HandleEvent() NN_NOEXCEPT
{
    if ( ::nn::os::TryWaitTimerEvent(&m_PeriodicCustomParameterSaveEvent) )
    {
        ::nn::os::ClearTimerEvent(&m_PeriodicCustomParameterSaveEvent);

        NN_ABORT_UNLESS_RESULT_SUCCESS(m_pFuelGaugeParameterManager->SaveParameter());

        return true;
    }

    return false;
}


}}}} // namespace nn::psm::driver::detail
