﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../psm_BatteryTemperatureManager.h"
#include "../psm_IFuelGaugeDriver.h"
#include "psm_EventHandler.h"

namespace nn { namespace psm { namespace driver { namespace detail {

//! NX における電池残量計関連イベントの処理を行うクラス
class FuelGaugeEventHandler final : public EventHandler
{
    NN_DISALLOW_COPY(FuelGaugeEventHandler);
    NN_DISALLOW_MOVE(FuelGaugeEventHandler);

public:
    FuelGaugeEventHandler() NN_NOEXCEPT;

    virtual ~FuelGaugeEventHandler() NN_NOEXCEPT NN_OVERRIDE;

    void Initialize(BatteryTemperatureManager* pTemperatureManager, IFuelGaugeDriver* pFuelGaugeDriver) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT NN_OVERRIDE;

    virtual void UnlinkMultiWaitHolders() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool HandleEvent() NN_NOEXCEPT NN_OVERRIDE;

    ::nn::Result GetFuelGaugeInterruptForTest(::nn::os::EventType** pOutEventPointer) NN_NOEXCEPT;

private:
    ::nn::Result ProcessFuelGaugeInterrupt() NN_NOEXCEPT;

private:
    //! 電池温度管理
    BatteryTemperatureManager* m_pTemperatureManager;

    //! 電池残量計ドライバ
    IFuelGaugeDriver* m_pFuelGaugeDriver;

    //! 電池残量計からの割り込みを検出するイベント
    ::nn::os::SystemEventType m_FuelGaugeInterruptEvent;
    ::nn::os::MultiWaitHolderType m_FuelGaugeInterruptMultiWaitHolder;

    //! テスト用途の電池残量 IC のハンドリング完了イベント
    ::nn::os::EventType m_FuelGaugeEvent;
};

}}}} // namespace nn::psm::driver::detail
