﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>

#include <nn/psc/psc_Types.h>
#include <nn/psc/psc_Result.h>
#include <nn/psc/psc_PmModuleId.h>

#include "psc_Allocator.h"

namespace nn     {
namespace psc    {
namespace server {

class PmModule;

class PmDependent :
    public nn::util::IntrusiveListBaseNode<PmDependent>,
    public Allocator
{
private:
    PmModule* m_pModule;

public:
    PmModuleId Id()
    NN_NOEXCEPT;

    PmModule* GetModulePointer()
    NN_NOEXCEPT;

    nn::Result AddChild(PmModule* pChild)
    NN_NOEXCEPT;

    nn::Result AddParent(PmModule* pParent)
    NN_NOEXCEPT;

    void RemoveChild(PmModule* pChild)
    NN_NOEXCEPT;

    void RemoveParent(PmModule* pParent)
    NN_NOEXCEPT;

    nn::Result ValidateDependency(PmModule* pParent, uint32_t iterationCounter)
    NN_NOEXCEPT;

    nn::Result DispatchDescendingOrder(nn::os::SystemEvent** pEventOut, PmState state, PmFlagSet flags, uint32_t iterationCounter)
    NN_NOEXCEPT;

    nn::Result DispatchAscendingOrder(nn::os::SystemEvent** pEventOut, PmState state, PmFlagSet flags, uint32_t iterationCounter)
    NN_NOEXCEPT;

    uint32_t ChildDependencyLevels(uint32_t* pLevelsOut, uint32_t iterationCounter)
    NN_NOEXCEPT;

    uint32_t ParentDependencyLevels(uint32_t* pLevelsOut, uint32_t iterationCounter)
    NN_NOEXCEPT;

    explicit PmDependent(PmModule* pModule)
    NN_NOEXCEPT;

    ~PmDependent()
    NN_NOEXCEPT;
};

}}}
