﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
// This file was automatically generated. Do not modify it directly.
#include <nvn/nvn.h>
#include <nvn/nvn_FuncPtr.h>
#include "profiler_nvn.h"
#ifdef __cplusplus
extern "C" {
#endif
const size_t NvnFunctionCount = 506;
namespace nn { namespace profiler {
extern char *gNvnFuncTable;
namespace nvn {

/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/







NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceBuilderSetDefaults(NVNdeviceBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEBUILDERSETDEFAULTSPROC)funcTable[0])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceBuilderSetFlags(NVNdeviceBuilder *builder, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEBUILDERSETFLAGSPROC)funcTable[1])(builder, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNdeviceFlagBits nvnDeviceBuilderGetFlags(const NVNdeviceBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEBUILDERGETFLAGSPROC)funcTable[2])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDeviceInitialize(NVNdevice *device, const NVNdeviceBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEINITIALIZEPROC)funcTable[3])(device, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceFinalize(NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEFINALIZEPROC)funcTable[4])(device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceSetDebugLabel(NVNdevice *device, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICESETDEBUGLABELPROC)funcTable[5])(device, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) PFNNVNGENERICFUNCPTRPROC nvnDeviceGetProcAddress(const NVNdevice *device, const char * name)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETPROCADDRESSPROC)funcTable[6])(device, name);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceGetInteger(const NVNdevice *device, NVNdeviceInfo pname, int *v)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEGETINTEGERPROC)funcTable[7])(device, pname, v);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint64_t nvnDeviceGetCurrentTimestampInNanoseconds(const NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETCURRENTTIMESTAMPINNANOSECONDSPROC)funcTable[8])(device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceSetIntermediateShaderCache(NVNdevice *device, int numMaxEntries)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICESETINTERMEDIATESHADERCACHEPROC)funcTable[9])(device, numMaxEntries);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureHandle nvnDeviceGetTextureHandle(const NVNdevice *device, int textureID, int samplerID)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETTEXTUREHANDLEPROC)funcTable[10])(device, textureID, samplerID);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureHandle nvnDeviceGetTexelFetchHandle(const NVNdevice *device, int textureID)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETTEXELFETCHHANDLEPROC)funcTable[11])(device, textureID);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNimageHandle nvnDeviceGetImageHandle(const NVNdevice *device, int imageID)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETIMAGEHANDLEPROC)funcTable[12])(device, imageID);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceInstallDebugCallback(NVNdevice *device, const PFNNVNDEBUGCALLBACKPROC callback, void *callbackData, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEINSTALLDEBUGCALLBACKPROC)funcTable[13])(device, callback, callbackData, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNdebugDomainId nvnDeviceGenerateDebugDomainId(const NVNdevice *device, const char * name)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGENERATEDEBUGDOMAINIDPROC)funcTable[14])(device, name);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceSetWindowOriginMode(NVNdevice *device, NVNwindowOriginMode windowOriginMode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICESETWINDOWORIGINMODEPROC)funcTable[15])(device, windowOriginMode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceSetDepthMode(NVNdevice *device, NVNdepthMode depthMode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICESETDEPTHMODEPROC)funcTable[16])(device, depthMode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDeviceRegisterFastClearColor(NVNdevice *device, const float *color, NVNformat format)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEREGISTERFASTCLEARCOLORPROC)funcTable[17])(device, color, format);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDeviceRegisterFastClearColori(NVNdevice *device, const int *color, NVNformat format)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEREGISTERFASTCLEARCOLORIPROC)funcTable[18])(device, color, format);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDeviceRegisterFastClearColorui(NVNdevice *device, const uint32_t *color, NVNformat format)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEREGISTERFASTCLEARCOLORUIPROC)funcTable[19])(device, color, format);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDeviceRegisterFastClearDepth(NVNdevice *device, float depth)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEREGISTERFASTCLEARDEPTHPROC)funcTable[20])(device, depth);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNwindowOriginMode nvnDeviceGetWindowOriginMode(const NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETWINDOWORIGINMODEPROC)funcTable[21])(device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNdepthMode nvnDeviceGetDepthMode(const NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETDEPTHMODEPROC)funcTable[22])(device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint64_t nvnDeviceGetTimestampInNanoseconds(const NVNdevice *device, const NVNcounterData *counterData)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETTIMESTAMPINNANOSECONDSPROC)funcTable[23])(device, counterData);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceApplyDeferredFinalizes(NVNdevice *device, int age)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEAPPLYDEFERREDFINALIZESPROC)funcTable[24])(device, age);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceFinalizeCommandHandle(NVNdevice *device, NVNcommandHandle handles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEFINALIZECOMMANDHANDLEPROC)funcTable[25])(device, handles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDeviceWalkDebugDatabase(const NVNdevice *device, NVNdebugObjectType type, PFNNVNWALKDEBUGDATABASECALLBACKPROC callback, void *userParam)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEVICEWALKDEBUGDATABASEPROC)funcTable[26])(device, type, callback, userParam);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNseparateTextureHandle nvnDeviceGetSeparateTextureHandle(const NVNdevice *device, int textureID)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETSEPARATETEXTUREHANDLEPROC)funcTable[27])(device, textureID);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNseparateSamplerHandle nvnDeviceGetSeparateSamplerHandle(const NVNdevice *device, int samplerID)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEGETSEPARATESAMPLERHANDLEPROC)funcTable[28])(device, samplerID);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDeviceIsExternalDebuggerAttached(const NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEVICEISEXTERNALDEBUGGERATTACHEDPROC)funcTable[29])(device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNqueueGetErrorResult nvnQueueGetError(NVNqueue *queue, NVNqueueErrorInfo *errorInfo)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEGETERRORPROC)funcTable[30])(queue, errorInfo);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnQueueGetTotalCommandMemoryUsed(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEGETTOTALCOMMANDMEMORYUSEDPROC)funcTable[31])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnQueueGetTotalControlMemoryUsed(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEGETTOTALCONTROLMEMORYUSEDPROC)funcTable[32])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnQueueGetTotalComputeMemoryUsed(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEGETTOTALCOMPUTEMEMORYUSEDPROC)funcTable[33])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueResetMemoryUsageCounts(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUERESETMEMORYUSAGECOUNTSPROC)funcTable[34])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetDevice(NVNqueueBuilder *builder, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETDEVICEPROC)funcTable[35])(builder, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetDefaults(NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETDEFAULTSPROC)funcTable[36])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetFlags(NVNqueueBuilder *builder, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETFLAGSPROC)funcTable[37])(builder, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetCommandMemorySize(NVNqueueBuilder *builder, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETCOMMANDMEMORYSIZEPROC)funcTable[38])(builder, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetComputeMemorySize(NVNqueueBuilder *builder, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETCOMPUTEMEMORYSIZEPROC)funcTable[39])(builder, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetControlMemorySize(NVNqueueBuilder *builder, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETCONTROLMEMORYSIZEPROC)funcTable[40])(builder, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnQueueBuilderGetQueueMemorySize(const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETQUEUEMEMORYSIZEPROC)funcTable[41])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetQueueMemory(NVNqueueBuilder *builder, void *memory, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETQUEUEMEMORYPROC)funcTable[42])(builder, memory, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetCommandFlushThreshold(NVNqueueBuilder *builder, size_t threshold)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETCOMMANDFLUSHTHRESHOLDPROC)funcTable[43])(builder, threshold);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueBuilderSetQueuePriority(NVNqueueBuilder *builder, const NVNqueuePriority priority)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEBUILDERSETQUEUEPRIORITYPROC)funcTable[44])(builder, priority);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNqueuePriority nvnQueueBuilderGetQueuePriority(const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETQUEUEPRIORITYPROC)funcTable[45])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNdevice * nvnQueueBuilderGetDevice(const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETDEVICEPROC)funcTable[46])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnQueueBuilderGetFlags(const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETFLAGSPROC)funcTable[47])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnQueueBuilderGetCommandMemorySize(const NVNqueueBuilder *builder, int *size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETCOMMANDMEMORYSIZEPROC)funcTable[48])(builder, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnQueueBuilderGetComputeMemorySize(const NVNqueueBuilder *builder, int *size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETCOMPUTEMEMORYSIZEPROC)funcTable[49])(builder, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnQueueBuilderGetControlMemorySize(const NVNqueueBuilder *builder, int *size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETCONTROLMEMORYSIZEPROC)funcTable[50])(builder, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnQueueBuilderGetCommandFlushThreshold(const NVNqueueBuilder *builder, int *flushThreshold)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETCOMMANDFLUSHTHRESHOLDPROC)funcTable[51])(builder, flushThreshold);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnQueueBuilderGetMemorySize(const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETMEMORYSIZEPROC)funcTable[52])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void* nvnQueueBuilderGetMemory(const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEBUILDERGETMEMORYPROC)funcTable[53])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnQueueInitialize(NVNqueue *queue, const NVNqueueBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEINITIALIZEPROC)funcTable[54])(queue, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueFinalize(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEFINALIZEPROC)funcTable[55])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueSetDebugLabel(NVNqueue *queue, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUESETDEBUGLABELPROC)funcTable[56])(queue, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueSubmitCommands(NVNqueue *queue, int numCommands, const NVNcommandHandle *handles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUESUBMITCOMMANDSPROC)funcTable[57])(queue, numCommands, handles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueFlush(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEFLUSHPROC)funcTable[58])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueFinish(NVNqueue *queue)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEFINISHPROC)funcTable[59])(queue);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueuePresentTexture(NVNqueue *queue, NVNwindow *window, int textureIndex)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEPRESENTTEXTUREPROC)funcTable[60])(queue, window, textureIndex);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNqueueAcquireTextureResult nvnQueueAcquireTexture(NVNqueue *queue, NVNwindow *window, int *textureIndex)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEACQUIRETEXTUREPROC)funcTable[61])(queue, window, textureIndex);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowBuilderSetDevice(NVNwindowBuilder *builder, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWBUILDERSETDEVICEPROC)funcTable[62])(builder, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowBuilderSetDefaults(NVNwindowBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWBUILDERSETDEFAULTSPROC)funcTable[63])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowBuilderSetNativeWindow(NVNwindowBuilder *builder, NVNnativeWindow nativeWindow)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWBUILDERSETNATIVEWINDOWPROC)funcTable[64])(builder, nativeWindow);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowBuilderSetTextures(NVNwindowBuilder *builder, int numTextures, NVNtexture * const *textures)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWBUILDERSETTEXTURESPROC)funcTable[65])(builder, numTextures, textures);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowBuilderSetPresentInterval(NVNwindowBuilder *builder, int presentInterval)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWBUILDERSETPRESENTINTERVALPROC)funcTable[66])(builder, presentInterval);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNdevice * nvnWindowBuilderGetDevice(const NVNwindowBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWBUILDERGETDEVICEPROC)funcTable[67])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnWindowBuilderGetNumTextures(const NVNwindowBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWBUILDERGETNUMTEXTURESPROC)funcTable[68])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNtexture * nvnWindowBuilderGetTexture(const NVNwindowBuilder *builder, int textureId)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWBUILDERGETTEXTUREPROC)funcTable[69])(builder, textureId);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNnativeWindow nvnWindowBuilderGetNativeWindow(const NVNwindowBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWBUILDERGETNATIVEWINDOWPROC)funcTable[70])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnWindowBuilderGetPresentInterval(const NVNwindowBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWBUILDERGETPRESENTINTERVALPROC)funcTable[71])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnWindowInitialize(NVNwindow *window, const NVNwindowBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWINITIALIZEPROC)funcTable[72])(window, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowFinalize(NVNwindow *window)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWFINALIZEPROC)funcTable[73])(window);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowSetDebugLabel(NVNwindow *window, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWSETDEBUGLABELPROC)funcTable[74])(window, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNwindowAcquireTextureResult nvnWindowAcquireTexture(NVNwindow *window, NVNsync *textureAvailableSync, int *textureIndex)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWACQUIRETEXTUREPROC)funcTable[75])(window, textureAvailableSync, textureIndex);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNnativeWindow nvnWindowGetNativeWindow(const NVNwindow *window)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWGETNATIVEWINDOWPROC)funcTable[76])(window);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnWindowGetPresentInterval(const NVNwindow *window)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNWINDOWGETPRESENTINTERVALPROC)funcTable[77])(window);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowSetPresentInterval(NVNwindow *window, int presentInterval)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWSETPRESENTINTERVALPROC)funcTable[78])(window, presentInterval);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowSetCrop(NVNwindow *window, int x, int y, int w, int h)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWSETCROPPROC)funcTable[79])(window, x, y, w, h);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnWindowGetCrop(const NVNwindow *window, NVNrectangle *crop)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNWINDOWGETCROPPROC)funcTable[80])(window, crop);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnProgramInitialize(NVNprogram *program, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPROGRAMINITIALIZEPROC)funcTable[81])(program, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnProgramFinalize(NVNprogram *program)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPROGRAMFINALIZEPROC)funcTable[82])(program);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnProgramSetDebugLabel(NVNprogram *program, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPROGRAMSETDEBUGLABELPROC)funcTable[83])(program, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnProgramSetShaders(NVNprogram *program, int count, const NVNshaderData *stageData)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPROGRAMSETSHADERSPROC)funcTable[84])(program, count, stageData);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnProgramSetShadersExt(NVNprogram *program, int count, const NVNshaderDataExt *stageDataExt)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPROGRAMSETSHADERSEXTPROC)funcTable[85])(program, count, stageDataExt);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolBuilderSetDevice(NVNmemoryPoolBuilder *builder, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLBUILDERSETDEVICEPROC)funcTable[86])(builder, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolBuilderSetDefaults(NVNmemoryPoolBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLBUILDERSETDEFAULTSPROC)funcTable[87])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolBuilderSetStorage(NVNmemoryPoolBuilder *builder, void *memory, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLBUILDERSETSTORAGEPROC)funcTable[88])(builder, memory, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolBuilderSetFlags(NVNmemoryPoolBuilder *builder, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLBUILDERSETFLAGSPROC)funcTable[89])(builder, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNdevice * nvnMemoryPoolBuilderGetDevice(const NVNmemoryPoolBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLBUILDERGETDEVICEPROC)funcTable[90])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void* nvnMemoryPoolBuilderGetMemory(const NVNmemoryPoolBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLBUILDERGETMEMORYPROC)funcTable[91])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnMemoryPoolBuilderGetSize(const NVNmemoryPoolBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLBUILDERGETSIZEPROC)funcTable[92])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNmemoryPoolFlags nvnMemoryPoolBuilderGetFlags(const NVNmemoryPoolBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLBUILDERGETFLAGSPROC)funcTable[93])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMemoryPoolInitialize(NVNmemoryPool *pool, const NVNmemoryPoolBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLINITIALIZEPROC)funcTable[94])(pool, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolSetDebugLabel(NVNmemoryPool *pool, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLSETDEBUGLABELPROC)funcTable[95])(pool, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolFinalize(NVNmemoryPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLFINALIZEPROC)funcTable[96])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void* nvnMemoryPoolMap(const NVNmemoryPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLMAPPROC)funcTable[97])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolFlushMappedRange(const NVNmemoryPool *pool, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLFLUSHMAPPEDRANGEPROC)funcTable[98])(pool, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMemoryPoolInvalidateMappedRange(const NVNmemoryPool *pool, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMEMORYPOOLINVALIDATEMAPPEDRANGEPROC)funcTable[99])(pool, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNbufferAddress nvnMemoryPoolGetBufferAddress(const NVNmemoryPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLGETBUFFERADDRESSPROC)funcTable[100])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMemoryPoolMapVirtual(NVNmemoryPool *virtualPool, int numRequests, const NVNmappingRequest *requests)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLMAPVIRTUALPROC)funcTable[101])(virtualPool, numRequests, requests);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnMemoryPoolGetSize(const NVNmemoryPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLGETSIZEPROC)funcTable[102])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNmemoryPoolFlags nvnMemoryPoolGetFlags(const NVNmemoryPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMEMORYPOOLGETFLAGSPROC)funcTable[103])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTexturePoolInitialize(NVNtexturePool *texturePool, const NVNmemoryPool *memoryPool, ptrdiff_t offset, int numDescriptors)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREPOOLINITIALIZEPROC)funcTable[104])(texturePool, memoryPool, offset, numDescriptors);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTexturePoolSetDebugLabel(NVNtexturePool *pool, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREPOOLSETDEBUGLABELPROC)funcTable[105])(pool, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTexturePoolFinalize(NVNtexturePool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREPOOLFINALIZEPROC)funcTable[106])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTexturePoolRegisterTexture(const NVNtexturePool *texturePool, int id, const NVNtexture *texture, const NVNtextureView *view)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREPOOLREGISTERTEXTUREPROC)funcTable[107])(texturePool, id, texture, view);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTexturePoolRegisterImage(const NVNtexturePool *texturePool, int id, const NVNtexture *texture, const NVNtextureView *view)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREPOOLREGISTERIMAGEPROC)funcTable[108])(texturePool, id, texture, view);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNmemoryPool * nvnTexturePoolGetMemoryPool(const NVNtexturePool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREPOOLGETMEMORYPOOLPROC)funcTable[109])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnTexturePoolGetMemoryOffset(const NVNtexturePool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREPOOLGETMEMORYOFFSETPROC)funcTable[110])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTexturePoolGetSize(const NVNtexturePool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREPOOLGETSIZEPROC)funcTable[111])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnSamplerPoolInitialize(NVNsamplerPool *samplerPool, const NVNmemoryPool *memoryPool, ptrdiff_t offset, int numDescriptors)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERPOOLINITIALIZEPROC)funcTable[112])(samplerPool, memoryPool, offset, numDescriptors);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerPoolSetDebugLabel(NVNsamplerPool *pool, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERPOOLSETDEBUGLABELPROC)funcTable[113])(pool, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerPoolFinalize(NVNsamplerPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERPOOLFINALIZEPROC)funcTable[114])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerPoolRegisterSampler(const NVNsamplerPool *samplerPool, int id, const NVNsampler *sampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERPOOLREGISTERSAMPLERPROC)funcTable[115])(samplerPool, id, sampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerPoolRegisterSamplerBuilder(const NVNsamplerPool *samplerPool, int id, const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERPOOLREGISTERSAMPLERBUILDERPROC)funcTable[116])(samplerPool, id, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNmemoryPool * nvnSamplerPoolGetMemoryPool(const NVNsamplerPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERPOOLGETMEMORYPOOLPROC)funcTable[117])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnSamplerPoolGetMemoryOffset(const NVNsamplerPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERPOOLGETMEMORYOFFSETPROC)funcTable[118])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnSamplerPoolGetSize(const NVNsamplerPool *pool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERPOOLGETSIZEPROC)funcTable[119])(pool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferBuilderSetDevice(NVNbufferBuilder *builder, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERBUILDERSETDEVICEPROC)funcTable[120])(builder, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferBuilderSetDefaults(NVNbufferBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERBUILDERSETDEFAULTSPROC)funcTable[121])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferBuilderSetStorage(NVNbufferBuilder *builder, NVNmemoryPool *pool, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERBUILDERSETSTORAGEPROC)funcTable[122])(builder, pool, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNdevice * nvnBufferBuilderGetDevice(const NVNbufferBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERBUILDERGETDEVICEPROC)funcTable[123])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNmemoryPool * nvnBufferBuilderGetMemoryPool(const NVNbufferBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERBUILDERGETMEMORYPOOLPROC)funcTable[124])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnBufferBuilderGetMemoryOffset(const NVNbufferBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERBUILDERGETMEMORYOFFSETPROC)funcTable[125])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnBufferBuilderGetSize(const NVNbufferBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERBUILDERGETSIZEPROC)funcTable[126])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnBufferInitialize(NVNbuffer *buffer, const NVNbufferBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERINITIALIZEPROC)funcTable[127])(buffer, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferSetDebugLabel(NVNbuffer *buffer, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERSETDEBUGLABELPROC)funcTable[128])(buffer, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferFinalize(NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERFINALIZEPROC)funcTable[129])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void* nvnBufferMap(const NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERMAPPROC)funcTable[130])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNbufferAddress nvnBufferGetAddress(const NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERGETADDRESSPROC)funcTable[131])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferFlushMappedRange(const NVNbuffer *buffer, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERFLUSHMAPPEDRANGEPROC)funcTable[132])(buffer, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBufferInvalidateMappedRange(const NVNbuffer *buffer, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBUFFERINVALIDATEMAPPEDRANGEPROC)funcTable[133])(buffer, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNmemoryPool * nvnBufferGetMemoryPool(const NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERGETMEMORYPOOLPROC)funcTable[134])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnBufferGetMemoryOffset(const NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERGETMEMORYOFFSETPROC)funcTable[135])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnBufferGetSize(const NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERGETSIZEPROC)funcTable[136])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint64_t nvnBufferGetDebugID(const NVNbuffer *buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBUFFERGETDEBUGIDPROC)funcTable[137])(buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetDevice(NVNtextureBuilder *builder, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETDEVICEPROC)funcTable[138])(builder, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetDefaults(NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETDEFAULTSPROC)funcTable[139])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetFlags(NVNtextureBuilder *builder, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETFLAGSPROC)funcTable[140])(builder, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetTarget(NVNtextureBuilder *builder, NVNtextureTarget target)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETTARGETPROC)funcTable[141])(builder, target);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetWidth(NVNtextureBuilder *builder, int width)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETWIDTHPROC)funcTable[142])(builder, width);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetHeight(NVNtextureBuilder *builder, int height)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETHEIGHTPROC)funcTable[143])(builder, height);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetDepth(NVNtextureBuilder *builder, int depth)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETDEPTHPROC)funcTable[144])(builder, depth);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetSize1D(NVNtextureBuilder *builder, int width)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSIZE1DPROC)funcTable[145])(builder, width);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetSize2D(NVNtextureBuilder *builder, int width, int height)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSIZE2DPROC)funcTable[146])(builder, width, height);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetSize3D(NVNtextureBuilder *builder, int width, int height, int depth)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSIZE3DPROC)funcTable[147])(builder, width, height, depth);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetLevels(NVNtextureBuilder *builder, int numLevels)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETLEVELSPROC)funcTable[148])(builder, numLevels);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetFormat(NVNtextureBuilder *builder, NVNformat format)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETFORMATPROC)funcTable[149])(builder, format);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetSamples(NVNtextureBuilder *builder, int samples)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSAMPLESPROC)funcTable[150])(builder, samples);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetSwizzle(NVNtextureBuilder *builder, NVNtextureSwizzle r, NVNtextureSwizzle g, NVNtextureSwizzle b, NVNtextureSwizzle a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSWIZZLEPROC)funcTable[151])(builder, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetDepthStencilMode(NVNtextureBuilder *builder, NVNtextureDepthStencilMode mode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETDEPTHSTENCILMODEPROC)funcTable[152])(builder, mode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnTextureBuilderGetStorageSize(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETSTORAGESIZEPROC)funcTable[153])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnTextureBuilderGetStorageAlignment(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETSTORAGEALIGNMENTPROC)funcTable[154])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetStorage(NVNtextureBuilder *builder, NVNmemoryPool *pool, ptrdiff_t offset)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSTORAGEPROC)funcTable[155])(builder, pool, offset);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetPackagedTextureData(NVNtextureBuilder *builder, const void *data)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETPACKAGEDTEXTUREDATAPROC)funcTable[156])(builder, data);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetPackagedTextureLayout(NVNtextureBuilder *builder, const NVNpackagedTextureLayout *layout)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETPACKAGEDTEXTURELAYOUTPROC)funcTable[157])(builder, layout);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetStride(NVNtextureBuilder *builder, ptrdiff_t stride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETSTRIDEPROC)funcTable[158])(builder, stride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderSetGLTextureName(NVNtextureBuilder *builder, uint32_t name)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERSETGLTEXTURENAMEPROC)funcTable[159])(builder, name);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNstorageClass nvnTextureBuilderGetStorageClass(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETSTORAGECLASSPROC)funcTable[160])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNdevice * nvnTextureBuilderGetDevice(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETDEVICEPROC)funcTable[161])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureFlags nvnTextureBuilderGetFlags(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETFLAGSPROC)funcTable[162])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureTarget nvnTextureBuilderGetTarget(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETTARGETPROC)funcTable[163])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureBuilderGetWidth(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETWIDTHPROC)funcTable[164])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureBuilderGetHeight(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETHEIGHTPROC)funcTable[165])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureBuilderGetDepth(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETDEPTHPROC)funcTable[166])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureBuilderGetLevels(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETLEVELSPROC)funcTable[167])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNformat nvnTextureBuilderGetFormat(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETFORMATPROC)funcTable[168])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureBuilderGetSamples(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETSAMPLESPROC)funcTable[169])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderGetSwizzle(const NVNtextureBuilder *builder, NVNtextureSwizzle *r, NVNtextureSwizzle *g, NVNtextureSwizzle *b, NVNtextureSwizzle *a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERGETSWIZZLEPROC)funcTable[170])(builder, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureDepthStencilMode nvnTextureBuilderGetDepthStencilMode(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETDEPTHSTENCILMODEPROC)funcTable[171])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const void * nvnTextureBuilderGetPackagedTextureData(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETPACKAGEDTEXTUREDATAPROC)funcTable[172])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureBuilderGetPackagedTextureLayout(const NVNtextureBuilder *builder, NVNpackagedTextureLayout *data)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETPACKAGEDTEXTURELAYOUTPROC)funcTable[173])(builder, data);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnTextureBuilderGetStride(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETSTRIDEPROC)funcTable[174])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureBuilderGetSparseTileLayout(const NVNtextureBuilder *builder, NVNtextureSparseTileLayout *layout)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREBUILDERGETSPARSETILELAYOUTPROC)funcTable[175])(builder, layout);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint32_t nvnTextureBuilderGetGLTextureName(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETGLTEXTURENAMEPROC)funcTable[176])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnTextureBuilderGetZCullStorageSize(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETZCULLSTORAGESIZEPROC)funcTable[177])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNmemoryPool * nvnTextureBuilderGetMemoryPool(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETMEMORYPOOLPROC)funcTable[178])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnTextureBuilderGetMemoryOffset(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETMEMORYOFFSETPROC)funcTable[179])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNrawStorageClass nvnTextureBuilderGetRawStorageClass(const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREBUILDERGETRAWSTORAGECLASSPROC)funcTable[180])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetDefaults(NVNtextureView *view)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETDEFAULTSPROC)funcTable[181])(view);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetLevels(NVNtextureView *view, int baseLevel, int numLevels)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETLEVELSPROC)funcTable[182])(view, baseLevel, numLevels);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetLayers(NVNtextureView *view, int minLayer, int numLayers)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETLAYERSPROC)funcTable[183])(view, minLayer, numLayers);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetFormat(NVNtextureView *view, NVNformat format)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETFORMATPROC)funcTable[184])(view, format);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetSwizzle(NVNtextureView *view, NVNtextureSwizzle r, NVNtextureSwizzle g, NVNtextureSwizzle b, NVNtextureSwizzle a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETSWIZZLEPROC)funcTable[185])(view, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetDepthStencilMode(NVNtextureView *view, NVNtextureDepthStencilMode mode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETDEPTHSTENCILMODEPROC)funcTable[186])(view, mode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureViewSetTarget(NVNtextureView *view, NVNtextureTarget target)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREVIEWSETTARGETPROC)funcTable[187])(view, target);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewGetLevels(const NVNtextureView *view, int *baseLevel, int *numLevels)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWGETLEVELSPROC)funcTable[188])(view, baseLevel, numLevels);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewGetLayers(const NVNtextureView *view, int *minLayer, int *numLayers)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWGETLAYERSPROC)funcTable[189])(view, minLayer, numLayers);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewGetFormat(const NVNtextureView *view, NVNformat *format)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWGETFORMATPROC)funcTable[190])(view, format);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewGetSwizzle(const NVNtextureView *view, NVNtextureSwizzle *r, NVNtextureSwizzle *g, NVNtextureSwizzle *b, NVNtextureSwizzle *a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWGETSWIZZLEPROC)funcTable[191])(view, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewGetDepthStencilMode(const NVNtextureView *view, NVNtextureDepthStencilMode *mode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWGETDEPTHSTENCILMODEPROC)funcTable[192])(view, mode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewGetTarget(const NVNtextureView *view, NVNtextureTarget *target)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWGETTARGETPROC)funcTable[193])(view, target);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureViewCompare(const NVNtextureView *view, const NVNtextureView *otherView)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREVIEWCOMPAREPROC)funcTable[194])(view, otherView);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureInitialize(NVNtexture *texture, const NVNtextureBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREINITIALIZEPROC)funcTable[195])(texture, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnTextureGetZCullStorageSize(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETZCULLSTORAGESIZEPROC)funcTable[196])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureFinalize(NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREFINALIZEPROC)funcTable[197])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureSetDebugLabel(NVNtexture *texture, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTURESETDEBUGLABELPROC)funcTable[198])(texture, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNstorageClass nvnTextureGetStorageClass(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETSTORAGECLASSPROC)funcTable[199])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnTextureGetViewOffset(const NVNtexture *texture, const NVNtextureView *textureView)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETVIEWOFFSETPROC)funcTable[200])(texture, textureView);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureFlags nvnTextureGetFlags(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETFLAGSPROC)funcTable[201])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureTarget nvnTextureGetTarget(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETTARGETPROC)funcTable[202])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureGetWidth(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETWIDTHPROC)funcTable[203])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureGetHeight(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETHEIGHTPROC)funcTable[204])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureGetDepth(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETDEPTHPROC)funcTable[205])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureGetLevels(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETLEVELSPROC)funcTable[206])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNformat nvnTextureGetFormat(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETFORMATPROC)funcTable[207])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureGetSamples(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETSAMPLESPROC)funcTable[208])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureGetSwizzle(const NVNtexture *texture, NVNtextureSwizzle *r, NVNtextureSwizzle *g, NVNtextureSwizzle *b, NVNtextureSwizzle *a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREGETSWIZZLEPROC)funcTable[209])(texture, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureDepthStencilMode nvnTextureGetDepthStencilMode(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETDEPTHSTENCILMODEPROC)funcTable[210])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnTextureGetStride(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETSTRIDEPROC)funcTable[211])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNtextureAddress nvnTextureGetTextureAddress(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETTEXTUREADDRESSPROC)funcTable[212])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureGetSparseTileLayout(const NVNtexture *texture, NVNtextureSparseTileLayout *layout)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREGETSPARSETILELAYOUTPROC)funcTable[213])(texture, layout);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureWriteTexels(const NVNtexture *texture, const NVNtextureView *textureView, const NVNcopyRegion *region, const void *data)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREWRITETEXELSPROC)funcTable[214])(texture, textureView, region, data);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureWriteTexelsStrided(const NVNtexture *texture, const NVNtextureView *textureView, const NVNcopyRegion *region, const void *data, ptrdiff_t rowStride, ptrdiff_t imageStride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREWRITETEXELSSTRIDEDPROC)funcTable[215])(texture, textureView, region, data, rowStride, imageStride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureReadTexels(const NVNtexture *texture, const NVNtextureView *textureView, const NVNcopyRegion *region, void *data)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREREADTEXELSPROC)funcTable[216])(texture, textureView, region, data);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureReadTexelsStrided(const NVNtexture *texture, const NVNtextureView *textureView, const NVNcopyRegion *region, void *data, ptrdiff_t rowStride, ptrdiff_t imageStride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREREADTEXELSSTRIDEDPROC)funcTable[217])(texture, textureView, region, data, rowStride, imageStride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureFlushTexels(const NVNtexture *texture, const NVNtextureView *textureView, const NVNcopyRegion *region)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREFLUSHTEXELSPROC)funcTable[218])(texture, textureView, region);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnTextureInvalidateTexels(const NVNtexture *texture, const NVNtextureView *textureView, const NVNcopyRegion *region)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNTEXTUREINVALIDATETEXELSPROC)funcTable[219])(texture, textureView, region);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNmemoryPool * nvnTextureGetMemoryPool(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETMEMORYPOOLPROC)funcTable[220])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnTextureGetMemoryOffset(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETMEMORYOFFSETPROC)funcTable[221])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnTextureGetStorageSize(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETSTORAGESIZEPROC)funcTable[222])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnTextureCompare(const NVNtexture *texture, const NVNtexture *otherTexture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTURECOMPAREPROC)funcTable[223])(texture, otherTexture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint64_t nvnTextureGetDebugID(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETDEBUGIDPROC)funcTable[224])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNrawStorageClass nvnTextureGetRawStorageClass(const NVNtexture *texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNTEXTUREGETRAWSTORAGECLASSPROC)funcTable[225])(texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetDevice(NVNsamplerBuilder *builder, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETDEVICEPROC)funcTable[226])(builder, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetDefaults(NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETDEFAULTSPROC)funcTable[227])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetMinMagFilter(NVNsamplerBuilder *builder, NVNminFilter min, NVNmagFilter mag)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETMINMAGFILTERPROC)funcTable[228])(builder, min, mag);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetWrapMode(NVNsamplerBuilder *builder, NVNwrapMode s, NVNwrapMode t, NVNwrapMode r)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETWRAPMODEPROC)funcTable[229])(builder, s, t, r);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetLodClamp(NVNsamplerBuilder *builder, float min, float max)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETLODCLAMPPROC)funcTable[230])(builder, min, max);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetLodBias(NVNsamplerBuilder *builder, float bias)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETLODBIASPROC)funcTable[231])(builder, bias);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetCompare(NVNsamplerBuilder *builder, NVNcompareMode mode, NVNcompareFunc func)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETCOMPAREPROC)funcTable[232])(builder, mode, func);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetBorderColor(NVNsamplerBuilder *builder, const float *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETBORDERCOLORPROC)funcTable[233])(builder, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetBorderColori(NVNsamplerBuilder *builder, const int *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETBORDERCOLORIPROC)funcTable[234])(builder, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetBorderColorui(NVNsamplerBuilder *builder, const uint32_t *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETBORDERCOLORUIPROC)funcTable[235])(builder, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetMaxAnisotropy(NVNsamplerBuilder *builder, float maxAniso)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETMAXANISOTROPYPROC)funcTable[236])(builder, maxAniso);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetReductionFilter(NVNsamplerBuilder *builder, NVNsamplerReduction filter)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETREDUCTIONFILTERPROC)funcTable[237])(builder, filter);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderSetLodSnap(NVNsamplerBuilder *builder, float lodSnap)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERSETLODSNAPPROC)funcTable[238])(builder, lodSnap);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNdevice * nvnSamplerBuilderGetDevice(const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERBUILDERGETDEVICEPROC)funcTable[239])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetMinMagFilter(const NVNsamplerBuilder *builder, NVNminFilter *min, NVNmagFilter *mag)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETMINMAGFILTERPROC)funcTable[240])(builder, min, mag);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetWrapMode(const NVNsamplerBuilder *builder, NVNwrapMode *s, NVNwrapMode *t, NVNwrapMode *r)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETWRAPMODEPROC)funcTable[241])(builder, s, t, r);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetLodClamp(const NVNsamplerBuilder *builder, float *min, float *max)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETLODCLAMPPROC)funcTable[242])(builder, min, max);
}

NN_NOINLINE __attribute__((disable_tail_calls)) float nvnSamplerBuilderGetLodBias(const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERBUILDERGETLODBIASPROC)funcTable[243])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetCompare(const NVNsamplerBuilder *builder, NVNcompareMode *mode, NVNcompareFunc *func)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETCOMPAREPROC)funcTable[244])(builder, mode, func);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetBorderColor(const NVNsamplerBuilder *builder, float *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETBORDERCOLORPROC)funcTable[245])(builder, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetBorderColori(const NVNsamplerBuilder *builder, int *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETBORDERCOLORIPROC)funcTable[246])(builder, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerBuilderGetBorderColorui(const NVNsamplerBuilder *builder, uint32_t *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERBUILDERGETBORDERCOLORUIPROC)funcTable[247])(builder, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) float nvnSamplerBuilderGetMaxAnisotropy(const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERBUILDERGETMAXANISOTROPYPROC)funcTable[248])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNsamplerReduction nvnSamplerBuilderGetReductionFilter(const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERBUILDERGETREDUCTIONFILTERPROC)funcTable[249])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) float nvnSamplerBuilderGetLodSnap(const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERBUILDERGETLODSNAPPROC)funcTable[250])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnSamplerInitialize(NVNsampler *sampler, const NVNsamplerBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERINITIALIZEPROC)funcTable[251])(sampler, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerFinalize(NVNsampler *sampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERFINALIZEPROC)funcTable[252])(sampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerSetDebugLabel(NVNsampler *sampler, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERSETDEBUGLABELPROC)funcTable[253])(sampler, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetMinMagFilter(const NVNsampler *sampler, NVNminFilter *min, NVNmagFilter *mag)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETMINMAGFILTERPROC)funcTable[254])(sampler, min, mag);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetWrapMode(const NVNsampler *sampler, NVNwrapMode *s, NVNwrapMode *t, NVNwrapMode *r)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETWRAPMODEPROC)funcTable[255])(sampler, s, t, r);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetLodClamp(const NVNsampler *sampler, float *min, float *max)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETLODCLAMPPROC)funcTable[256])(sampler, min, max);
}

NN_NOINLINE __attribute__((disable_tail_calls)) float nvnSamplerGetLodBias(const NVNsampler *sampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERGETLODBIASPROC)funcTable[257])(sampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetCompare(const NVNsampler *sampler, NVNcompareMode *mode, NVNcompareFunc *func)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETCOMPAREPROC)funcTable[258])(sampler, mode, func);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetBorderColor(const NVNsampler *sampler, float *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETBORDERCOLORPROC)funcTable[259])(sampler, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetBorderColori(const NVNsampler *sampler, int *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETBORDERCOLORIPROC)funcTable[260])(sampler, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSamplerGetBorderColorui(const NVNsampler *sampler, uint32_t *borderColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSAMPLERGETBORDERCOLORUIPROC)funcTable[261])(sampler, borderColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) float nvnSamplerGetMaxAnisotropy(const NVNsampler *sampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERGETMAXANISOTROPYPROC)funcTable[262])(sampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNsamplerReduction nvnSamplerGetReductionFilter(const NVNsampler *sampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERGETREDUCTIONFILTERPROC)funcTable[263])(sampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnSamplerCompare(const NVNsampler *sampler, const NVNsampler *otherSampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERCOMPAREPROC)funcTable[264])(sampler, otherSampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint64_t nvnSamplerGetDebugID(const NVNsampler *sampler)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSAMPLERGETDEBUGIDPROC)funcTable[265])(sampler);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetDefaults(NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETDEFAULTSPROC)funcTable[266])(blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetBlendTarget(NVNblendState *blend, int target)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETBLENDTARGETPROC)funcTable[267])(blend, target);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetBlendFunc(NVNblendState *blend, NVNblendFunc srcFunc, NVNblendFunc dstFunc, NVNblendFunc srcFuncAlpha, NVNblendFunc dstFuncAlpha)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETBLENDFUNCPROC)funcTable[268])(blend, srcFunc, dstFunc, srcFuncAlpha, dstFuncAlpha);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetBlendEquation(NVNblendState *blend, NVNblendEquation modeRGB, NVNblendEquation modeAlpha)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETBLENDEQUATIONPROC)funcTable[269])(blend, modeRGB, modeAlpha);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetAdvancedMode(NVNblendState *blend, NVNblendAdvancedMode overlap)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETADVANCEDMODEPROC)funcTable[270])(blend, overlap);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetAdvancedOverlap(NVNblendState *blend, NVNblendAdvancedOverlap overlap)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETADVANCEDOVERLAPPROC)funcTable[271])(blend, overlap);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetAdvancedPremultipliedSrc(NVNblendState *blend, NVNboolean premultiplied)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETADVANCEDPREMULTIPLIEDSRCPROC)funcTable[272])(blend, premultiplied);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateSetAdvancedNormalizedDst(NVNblendState *blend, NVNboolean normalized)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATESETADVANCEDNORMALIZEDDSTPROC)funcTable[273])(blend, normalized);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnBlendStateGetBlendTarget(const NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBLENDSTATEGETBLENDTARGETPROC)funcTable[274])(blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateGetBlendFunc(const NVNblendState *blend, NVNblendFunc *srcFunc, NVNblendFunc *dstFunc, NVNblendFunc *srcFuncAlpha, NVNblendFunc *dstFuncAlpha)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATEGETBLENDFUNCPROC)funcTable[275])(blend, srcFunc, dstFunc, srcFuncAlpha, dstFuncAlpha);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnBlendStateGetBlendEquation(const NVNblendState *blend, NVNblendEquation *modeRGB, NVNblendEquation *modeAlpha)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNBLENDSTATEGETBLENDEQUATIONPROC)funcTable[276])(blend, modeRGB, modeAlpha);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNblendAdvancedMode nvnBlendStateGetAdvancedMode(const NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBLENDSTATEGETADVANCEDMODEPROC)funcTable[277])(blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNblendAdvancedOverlap nvnBlendStateGetAdvancedOverlap(const NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBLENDSTATEGETADVANCEDOVERLAPPROC)funcTable[278])(blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnBlendStateGetAdvancedPremultipliedSrc(const NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBLENDSTATEGETADVANCEDPREMULTIPLIEDSRCPROC)funcTable[279])(blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnBlendStateGetAdvancedNormalizedDst(const NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNBLENDSTATEGETADVANCEDNORMALIZEDDSTPROC)funcTable[280])(blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnColorStateSetDefaults(NVNcolorState *color)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOLORSTATESETDEFAULTSPROC)funcTable[281])(color);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnColorStateSetBlendEnable(NVNcolorState *color, int index, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOLORSTATESETBLENDENABLEPROC)funcTable[282])(color, index, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnColorStateSetLogicOp(NVNcolorState *color, NVNlogicOp logicOp)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOLORSTATESETLOGICOPPROC)funcTable[283])(color, logicOp);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnColorStateSetAlphaTest(NVNcolorState *color, NVNalphaFunc alphaTest)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOLORSTATESETALPHATESTPROC)funcTable[284])(color, alphaTest);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnColorStateGetBlendEnable(const NVNcolorState *color, int index)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOLORSTATEGETBLENDENABLEPROC)funcTable[285])(color, index);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNlogicOp nvnColorStateGetLogicOp(const NVNcolorState *color)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOLORSTATEGETLOGICOPPROC)funcTable[286])(color);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNalphaFunc nvnColorStateGetAlphaTest(const NVNcolorState *color)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOLORSTATEGETALPHATESTPROC)funcTable[287])(color);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnChannelMaskStateSetDefaults(NVNchannelMaskState *channelMask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCHANNELMASKSTATESETDEFAULTSPROC)funcTable[288])(channelMask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnChannelMaskStateSetChannelMask(NVNchannelMaskState *channelMask, int index, NVNboolean r, NVNboolean g, NVNboolean b, NVNboolean a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCHANNELMASKSTATESETCHANNELMASKPROC)funcTable[289])(channelMask, index, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnChannelMaskStateGetChannelMask(const NVNchannelMaskState *channelMask, int index, NVNboolean *r, NVNboolean *g, NVNboolean *b, NVNboolean *a)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCHANNELMASKSTATEGETCHANNELMASKPROC)funcTable[290])(channelMask, index, r, g, b, a);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetDefaults(NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETDEFAULTSPROC)funcTable[291])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetMultisampleEnable(NVNmultisampleState *multisample, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETMULTISAMPLEENABLEPROC)funcTable[292])(multisample, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetSamples(NVNmultisampleState *multisample, int samples)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETSAMPLESPROC)funcTable[293])(multisample, samples);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetAlphaToCoverageEnable(NVNmultisampleState *multisample, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETALPHATOCOVERAGEENABLEPROC)funcTable[294])(multisample, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetAlphaToCoverageDither(NVNmultisampleState *multisample, NVNboolean dither)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETALPHATOCOVERAGEDITHERPROC)funcTable[295])(multisample, dither);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMultisampleStateGetMultisampleEnable(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETMULTISAMPLEENABLEPROC)funcTable[296])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnMultisampleStateGetSamples(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETSAMPLESPROC)funcTable[297])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMultisampleStateGetAlphaToCoverageEnable(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETALPHATOCOVERAGEENABLEPROC)funcTable[298])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMultisampleStateGetAlphaToCoverageDither(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETALPHATOCOVERAGEDITHERPROC)funcTable[299])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetRasterSamples(NVNmultisampleState *multisample, int rasterSamples)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETRASTERSAMPLESPROC)funcTable[300])(multisample, rasterSamples);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnMultisampleStateGetRasterSamples(NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETRASTERSAMPLESPROC)funcTable[301])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetCoverageModulationMode(NVNmultisampleState *multisample, NVNcoverageModulationMode mode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETCOVERAGEMODULATIONMODEPROC)funcTable[302])(multisample, mode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNcoverageModulationMode nvnMultisampleStateGetCoverageModulationMode(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETCOVERAGEMODULATIONMODEPROC)funcTable[303])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetCoverageToColorEnable(NVNmultisampleState *multisample, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETCOVERAGETOCOLORENABLEPROC)funcTable[304])(multisample, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMultisampleStateGetCoverageToColorEnable(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETCOVERAGETOCOLORENABLEPROC)funcTable[305])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetCoverageToColorOutput(NVNmultisampleState *multisample, int color)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETCOVERAGETOCOLOROUTPUTPROC)funcTable[306])(multisample, color);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnMultisampleStateGetCoverageToColorOutput(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETCOVERAGETOCOLOROUTPUTPROC)funcTable[307])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetSampleLocationsEnable(NVNmultisampleState *multisample, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETSAMPLELOCATIONSENABLEPROC)funcTable[308])(multisample, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMultisampleStateGetSampleLocationsEnable(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETSAMPLELOCATIONSENABLEPROC)funcTable[309])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateGetSampleLocationsGrid(NVNmultisampleState *multisample, int *width, int *height)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATEGETSAMPLELOCATIONSGRIDPROC)funcTable[310])(multisample, width, height);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetSampleLocationsGridEnable(NVNmultisampleState *multisample, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETSAMPLELOCATIONSGRIDENABLEPROC)funcTable[311])(multisample, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnMultisampleStateGetSampleLocationsGridEnable(const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNMULTISAMPLESTATEGETSAMPLELOCATIONSGRIDENABLEPROC)funcTable[312])(multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnMultisampleStateSetSampleLocations(NVNmultisampleState *multisample, int start, int count, const float *values)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNMULTISAMPLESTATESETSAMPLELOCATIONSPROC)funcTable[313])(multisample, start, count, values);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnPolygonStateSetDefaults(NVNpolygonState *polygon)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPOLYGONSTATESETDEFAULTSPROC)funcTable[314])(polygon);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnPolygonStateSetCullFace(NVNpolygonState *polygon, NVNface face)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPOLYGONSTATESETCULLFACEPROC)funcTable[315])(polygon, face);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnPolygonStateSetFrontFace(NVNpolygonState *polygon, NVNfrontFace face)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPOLYGONSTATESETFRONTFACEPROC)funcTable[316])(polygon, face);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnPolygonStateSetPolygonMode(NVNpolygonState *polygon, NVNpolygonMode polygonMode)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPOLYGONSTATESETPOLYGONMODEPROC)funcTable[317])(polygon, polygonMode);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnPolygonStateSetPolygonOffsetEnables(NVNpolygonState *polygon, int enables)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNPOLYGONSTATESETPOLYGONOFFSETENABLESPROC)funcTable[318])(polygon, enables);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNface nvnPolygonStateGetCullFace(const NVNpolygonState *polygon)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPOLYGONSTATEGETCULLFACEPROC)funcTable[319])(polygon);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNfrontFace nvnPolygonStateGetFrontFace(const NVNpolygonState *polygon)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPOLYGONSTATEGETFRONTFACEPROC)funcTable[320])(polygon);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNpolygonMode nvnPolygonStateGetPolygonMode(const NVNpolygonState *polygon)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPOLYGONSTATEGETPOLYGONMODEPROC)funcTable[321])(polygon);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNpolygonOffsetEnable nvnPolygonStateGetPolygonOffsetEnables(const NVNpolygonState *polygon)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPOLYGONSTATEGETPOLYGONOFFSETENABLESPROC)funcTable[322])(polygon);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetDefaults(NVNdepthStencilState *depthStencil)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETDEFAULTSPROC)funcTable[323])(depthStencil);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetDepthTestEnable(NVNdepthStencilState *depthStencil, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETDEPTHTESTENABLEPROC)funcTable[324])(depthStencil, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetDepthWriteEnable(NVNdepthStencilState *depthStencil, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETDEPTHWRITEENABLEPROC)funcTable[325])(depthStencil, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetDepthFunc(NVNdepthStencilState *depthStencil, NVNdepthFunc func)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETDEPTHFUNCPROC)funcTable[326])(depthStencil, func);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetStencilTestEnable(NVNdepthStencilState *depthStencil, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETSTENCILTESTENABLEPROC)funcTable[327])(depthStencil, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetStencilFunc(NVNdepthStencilState *depthStencil, NVNface faces, NVNstencilFunc func)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETSTENCILFUNCPROC)funcTable[328])(depthStencil, faces, func);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateSetStencilOp(NVNdepthStencilState *depthStencil, NVNface faces, NVNstencilOp fail, NVNstencilOp depthFail, NVNstencilOp depthPass)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATESETSTENCILOPPROC)funcTable[329])(depthStencil, faces, fail, depthFail, depthPass);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDepthStencilStateGetDepthTestEnable(const NVNdepthStencilState *depthStencil)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEPTHSTENCILSTATEGETDEPTHTESTENABLEPROC)funcTable[330])(depthStencil);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDepthStencilStateGetDepthWriteEnable(const NVNdepthStencilState *depthStencil)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEPTHSTENCILSTATEGETDEPTHWRITEENABLEPROC)funcTable[331])(depthStencil);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNdepthFunc nvnDepthStencilStateGetDepthFunc(const NVNdepthStencilState *depthStencil)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEPTHSTENCILSTATEGETDEPTHFUNCPROC)funcTable[332])(depthStencil);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnDepthStencilStateGetStencilTestEnable(const NVNdepthStencilState *depthStencil)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEPTHSTENCILSTATEGETSTENCILTESTENABLEPROC)funcTable[333])(depthStencil);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNstencilFunc nvnDepthStencilStateGetStencilFunc(const NVNdepthStencilState *depthStencil, NVNface face)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNDEPTHSTENCILSTATEGETSTENCILFUNCPROC)funcTable[334])(depthStencil, face);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnDepthStencilStateGetStencilOp(const NVNdepthStencilState *depthStencil, NVNface face, NVNstencilOp *fail, NVNstencilOp *depthFail, NVNstencilOp *depthPass)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNDEPTHSTENCILSTATEGETSTENCILOPPROC)funcTable[335])(depthStencil, face, fail, depthFail, depthPass);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexAttribStateSetDefaults(NVNvertexAttribState *attrib)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXATTRIBSTATESETDEFAULTSPROC)funcTable[336])(attrib);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexAttribStateSetFormat(NVNvertexAttribState *attrib, NVNformat format, ptrdiff_t relativeOffset)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXATTRIBSTATESETFORMATPROC)funcTable[337])(attrib, format, relativeOffset);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexAttribStateSetStreamIndex(NVNvertexAttribState *attrib, int streamIndex)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXATTRIBSTATESETSTREAMINDEXPROC)funcTable[338])(attrib, streamIndex);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexAttribStateGetFormat(const NVNvertexAttribState *attrib, NVNformat *format, ptrdiff_t *relativeOffset)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXATTRIBSTATEGETFORMATPROC)funcTable[339])(attrib, format, relativeOffset);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnVertexAttribStateGetStreamIndex(const NVNvertexAttribState *attrib)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNVERTEXATTRIBSTATEGETSTREAMINDEXPROC)funcTable[340])(attrib);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexStreamStateSetDefaults(NVNvertexStreamState *stream)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXSTREAMSTATESETDEFAULTSPROC)funcTable[341])(stream);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexStreamStateSetStride(NVNvertexStreamState *stream, ptrdiff_t stride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXSTREAMSTATESETSTRIDEPROC)funcTable[342])(stream, stride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnVertexStreamStateSetDivisor(NVNvertexStreamState *stream, int divisor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNVERTEXSTREAMSTATESETDIVISORPROC)funcTable[343])(stream, divisor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnVertexStreamStateGetStride(const NVNvertexStreamState *stream)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNVERTEXSTREAMSTATEGETSTRIDEPROC)funcTable[344])(stream);
}

NN_NOINLINE __attribute__((disable_tail_calls)) int nvnVertexStreamStateGetDivisor(const NVNvertexStreamState *stream)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNVERTEXSTREAMSTATEGETDIVISORPROC)funcTable[345])(stream);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnCommandBufferInitialize(NVNcommandBuffer *cmdBuf, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERINITIALIZEPROC)funcTable[346])(cmdBuf, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferFinalize(NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERFINALIZEPROC)funcTable[347])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetDebugLabel(NVNcommandBuffer *cmdBuf, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETDEBUGLABELPROC)funcTable[348])(cmdBuf, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetMemoryCallback(NVNcommandBuffer *cmdBuf, PFNNVNCOMMANDBUFFERMEMORYCALLBACKPROC callback)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETMEMORYCALLBACKPROC)funcTable[349])(cmdBuf, callback);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetMemoryCallbackData(NVNcommandBuffer *cmdBuf, void *callbackData)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETMEMORYCALLBACKDATAPROC)funcTable[350])(cmdBuf, callbackData);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetCommandMemoryCallbackEnabled(NVNcommandBuffer *cmdBuf, NVNboolean enabled)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCOMMANDMEMORYCALLBACKENABLEDPROC)funcTable[351])(cmdBuf, enabled);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferAddCommandMemory(NVNcommandBuffer *cmdBuf, const NVNmemoryPool *pool, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERADDCOMMANDMEMORYPROC)funcTable[352])(cmdBuf, pool, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferAddControlMemory(NVNcommandBuffer *cmdBuf, void *memory, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERADDCONTROLMEMORYPROC)funcTable[353])(cmdBuf, memory, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnCommandBufferGetCommandMemorySize(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCOMMANDMEMORYSIZEPROC)funcTable[354])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnCommandBufferGetCommandMemoryUsed(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCOMMANDMEMORYUSEDPROC)funcTable[355])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnCommandBufferGetCommandMemoryFree(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCOMMANDMEMORYFREEPROC)funcTable[356])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnCommandBufferGetControlMemorySize(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCONTROLMEMORYSIZEPROC)funcTable[357])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnCommandBufferGetControlMemoryUsed(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCONTROLMEMORYUSEDPROC)funcTable[358])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) size_t nvnCommandBufferGetControlMemoryFree(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCONTROLMEMORYFREEPROC)funcTable[359])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBeginRecording(NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBEGINRECORDINGPROC)funcTable[360])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNcommandHandle nvnCommandBufferEndRecording(NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERENDRECORDINGPROC)funcTable[361])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferCallCommands(NVNcommandBuffer *cmdBuf, int numCommands, const NVNcommandHandle *handles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCALLCOMMANDSPROC)funcTable[362])(cmdBuf, numCommands, handles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferCopyCommands(NVNcommandBuffer *cmdBuf, int numCommands, const NVNcommandHandle *handles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCOPYCOMMANDSPROC)funcTable[363])(cmdBuf, numCommands, handles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindBlendState(NVNcommandBuffer *cmdBuf, const NVNblendState *blend)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDBLENDSTATEPROC)funcTable[364])(cmdBuf, blend);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindChannelMaskState(NVNcommandBuffer *cmdBuf, const NVNchannelMaskState *channelMask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDCHANNELMASKSTATEPROC)funcTable[365])(cmdBuf, channelMask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindColorState(NVNcommandBuffer *cmdBuf, const NVNcolorState *color)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDCOLORSTATEPROC)funcTable[366])(cmdBuf, color);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindMultisampleState(NVNcommandBuffer *cmdBuf, const NVNmultisampleState *multisample)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDMULTISAMPLESTATEPROC)funcTable[367])(cmdBuf, multisample);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindPolygonState(NVNcommandBuffer *cmdBuf, const NVNpolygonState *polygon)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDPOLYGONSTATEPROC)funcTable[368])(cmdBuf, polygon);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindDepthStencilState(NVNcommandBuffer *cmdBuf, const NVNdepthStencilState *depthStencil)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDDEPTHSTENCILSTATEPROC)funcTable[369])(cmdBuf, depthStencil);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindVertexAttribState(NVNcommandBuffer *cmdBuf, int numAttribs, const NVNvertexAttribState *attribs)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDVERTEXATTRIBSTATEPROC)funcTable[370])(cmdBuf, numAttribs, attribs);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindVertexStreamState(NVNcommandBuffer *cmdBuf, int numStreams, const NVNvertexStreamState *streams)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDVERTEXSTREAMSTATEPROC)funcTable[371])(cmdBuf, numStreams, streams);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindProgram(NVNcommandBuffer *cmdBuf, const NVNprogram *program, int stages)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDPROGRAMPROC)funcTable[372])(cmdBuf, program, stages);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindVertexBuffer(NVNcommandBuffer *cmdBuf, int index, NVNbufferAddress buffer, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDVERTEXBUFFERPROC)funcTable[373])(cmdBuf, index, buffer, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindVertexBuffers(NVNcommandBuffer *cmdBuf, int first, int count, const NVNbufferRange *buffers)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDVERTEXBUFFERSPROC)funcTable[374])(cmdBuf, first, count, buffers);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindUniformBuffer(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int index, NVNbufferAddress buffer, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDUNIFORMBUFFERPROC)funcTable[375])(cmdBuf, stage, index, buffer, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindUniformBuffers(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int first, int count, const NVNbufferRange *buffers)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDUNIFORMBUFFERSPROC)funcTable[376])(cmdBuf, stage, first, count, buffers);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindTransformFeedbackBuffer(NVNcommandBuffer *cmdBuf, int index, NVNbufferAddress buffer, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDTRANSFORMFEEDBACKBUFFERPROC)funcTable[377])(cmdBuf, index, buffer, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindTransformFeedbackBuffers(NVNcommandBuffer *cmdBuf, int first, int count, const NVNbufferRange *buffers)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDTRANSFORMFEEDBACKBUFFERSPROC)funcTable[378])(cmdBuf, first, count, buffers);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindStorageBuffer(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int index, NVNbufferAddress buffer, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDSTORAGEBUFFERPROC)funcTable[379])(cmdBuf, stage, index, buffer, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindStorageBuffers(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int first, int count, const NVNbufferRange *buffers)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDSTORAGEBUFFERSPROC)funcTable[380])(cmdBuf, stage, first, count, buffers);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindTexture(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int index, NVNtextureHandle texture)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDTEXTUREPROC)funcTable[381])(cmdBuf, stage, index, texture);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindTextures(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int first, int count, const NVNtextureHandle *textures)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDTEXTURESPROC)funcTable[382])(cmdBuf, stage, first, count, textures);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindImage(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int index, NVNimageHandle image)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDIMAGEPROC)funcTable[383])(cmdBuf, stage, index, image);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindImages(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int first, int count, const NVNimageHandle *images)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDIMAGESPROC)funcTable[384])(cmdBuf, stage, first, count, images);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetPatchSize(NVNcommandBuffer *cmdBuf, int size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETPATCHSIZEPROC)funcTable[385])(cmdBuf, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetInnerTessellationLevels(NVNcommandBuffer *cmdBuf, const float *levels)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETINNERTESSELLATIONLEVELSPROC)funcTable[386])(cmdBuf, levels);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetOuterTessellationLevels(NVNcommandBuffer *cmdBuf, const float *levels)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETOUTERTESSELLATIONLEVELSPROC)funcTable[387])(cmdBuf, levels);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetPrimitiveRestart(NVNcommandBuffer *cmdBuf, NVNboolean enable, int index)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETPRIMITIVERESTARTPROC)funcTable[388])(cmdBuf, enable, index);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBeginTransformFeedback(NVNcommandBuffer *cmdBuf, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBEGINTRANSFORMFEEDBACKPROC)funcTable[389])(cmdBuf, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferEndTransformFeedback(NVNcommandBuffer *cmdBuf, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERENDTRANSFORMFEEDBACKPROC)funcTable[390])(cmdBuf, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferPauseTransformFeedback(NVNcommandBuffer *cmdBuf, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERPAUSETRANSFORMFEEDBACKPROC)funcTable[391])(cmdBuf, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferResumeTransformFeedback(NVNcommandBuffer *cmdBuf, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERRESUMETRANSFORMFEEDBACKPROC)funcTable[392])(cmdBuf, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawTransformFeedback(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWTRANSFORMFEEDBACKPROC)funcTable[393])(cmdBuf, mode, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawArrays(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, int first, int count)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWARRAYSPROC)funcTable[394])(cmdBuf, mode, first, count);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawElements(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNindexType type, int count, NVNbufferAddress indexBuffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWELEMENTSPROC)funcTable[395])(cmdBuf, mode, type, count, indexBuffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawElementsBaseVertex(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNindexType type, int count, NVNbufferAddress indexBuffer, int baseVertex)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWELEMENTSBASEVERTEXPROC)funcTable[396])(cmdBuf, mode, type, count, indexBuffer, baseVertex);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawArraysInstanced(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, int first, int count, int baseInstance, int instanceCount)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWARRAYSINSTANCEDPROC)funcTable[397])(cmdBuf, mode, first, count, baseInstance, instanceCount);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawElementsInstanced(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNindexType type, int count, NVNbufferAddress indexBuffer, int baseVertex, int baseInstance, int instanceCount)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWELEMENTSINSTANCEDPROC)funcTable[398])(cmdBuf, mode, type, count, indexBuffer, baseVertex, baseInstance, instanceCount);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawArraysIndirect(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNbufferAddress indirectBuffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWARRAYSINDIRECTPROC)funcTable[399])(cmdBuf, mode, indirectBuffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawElementsIndirect(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNindexType type, NVNbufferAddress indexBuffer, NVNbufferAddress indirectBuffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWELEMENTSINDIRECTPROC)funcTable[400])(cmdBuf, mode, type, indexBuffer, indirectBuffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferMultiDrawArraysIndirectCount(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNbufferAddress indirectBuffer, NVNbufferAddress parameterBuffer, int maxDrawCount, ptrdiff_t stride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERMULTIDRAWARRAYSINDIRECTCOUNTPROC)funcTable[401])(cmdBuf, mode, indirectBuffer, parameterBuffer, maxDrawCount, stride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferMultiDrawElementsIndirectCount(NVNcommandBuffer *cmdBuf, NVNdrawPrimitive mode, NVNindexType type, NVNbufferAddress indexBuffer, NVNbufferAddress indirectBuffer, NVNbufferAddress parameterBuffer, int maxDrawCount, ptrdiff_t stride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERMULTIDRAWELEMENTSINDIRECTCOUNTPROC)funcTable[402])(cmdBuf, mode, type, indexBuffer, indirectBuffer, parameterBuffer, maxDrawCount, stride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearColor(NVNcommandBuffer *cmdBuf, int index, const float *color, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARCOLORPROC)funcTable[403])(cmdBuf, index, color, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearColori(NVNcommandBuffer *cmdBuf, int index, const int *color, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARCOLORIPROC)funcTable[404])(cmdBuf, index, color, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearColorui(NVNcommandBuffer *cmdBuf, int index, const uint32_t *color, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARCOLORUIPROC)funcTable[405])(cmdBuf, index, color, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearDepthStencil(NVNcommandBuffer *cmdBuf, float depthValue, NVNboolean depthMask, int stencilValue, int stencilMask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARDEPTHSTENCILPROC)funcTable[406])(cmdBuf, depthValue, depthMask, stencilValue, stencilMask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDispatchCompute(NVNcommandBuffer *cmdBuf, int groupsX, int groupsY, int groupsZ)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDISPATCHCOMPUTEPROC)funcTable[407])(cmdBuf, groupsX, groupsY, groupsZ);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDispatchComputeIndirect(NVNcommandBuffer *cmdBuf, NVNbufferAddress indirectBuffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDISPATCHCOMPUTEINDIRECTPROC)funcTable[408])(cmdBuf, indirectBuffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetViewport(NVNcommandBuffer *cmdBuf, int x, int y, int w, int h)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETVIEWPORTPROC)funcTable[409])(cmdBuf, x, y, w, h);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetViewports(NVNcommandBuffer *cmdBuf, int first, int count, const float *ranges)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETVIEWPORTSPROC)funcTable[410])(cmdBuf, first, count, ranges);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetViewportSwizzles(NVNcommandBuffer *cmdBuf, int first, int count, const NVNviewportSwizzle *swizzles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETVIEWPORTSWIZZLESPROC)funcTable[411])(cmdBuf, first, count, swizzles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetScissor(NVNcommandBuffer *cmdBuf, int x, int y, int w, int h)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSCISSORPROC)funcTable[412])(cmdBuf, x, y, w, h);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetScissors(NVNcommandBuffer *cmdBuf, int first, int count, const int *rects)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSCISSORSPROC)funcTable[413])(cmdBuf, first, count, rects);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetDepthRange(NVNcommandBuffer *cmdBuf, float n, float f)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETDEPTHRANGEPROC)funcTable[414])(cmdBuf, n, f);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetDepthBounds(NVNcommandBuffer *cmdBuf, NVNboolean enable, float n, float f)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETDEPTHBOUNDSPROC)funcTable[415])(cmdBuf, enable, n, f);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetDepthRanges(NVNcommandBuffer *cmdBuf, int first, int count, const float *ranges)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETDEPTHRANGESPROC)funcTable[416])(cmdBuf, first, count, ranges);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetTiledCacheAction(NVNcommandBuffer *cmdBuf, NVNtiledCacheAction action)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETTILEDCACHEACTIONPROC)funcTable[417])(cmdBuf, action);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetTiledCacheTileSize(NVNcommandBuffer *cmdBuf, int tileWidth, int tileHeight)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETTILEDCACHETILESIZEPROC)funcTable[418])(cmdBuf, tileWidth, tileHeight);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindSeparateTexture(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int index, NVNseparateTextureHandle textureHandle)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDSEPARATETEXTUREPROC)funcTable[419])(cmdBuf, stage, index, textureHandle);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindSeparateSampler(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int index, NVNseparateSamplerHandle samplerHandle)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDSEPARATESAMPLERPROC)funcTable[420])(cmdBuf, stage, index, samplerHandle);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindSeparateTextures(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int first, int count, const NVNseparateTextureHandle *textureHandles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDSEPARATETEXTURESPROC)funcTable[421])(cmdBuf, stage, first, count, textureHandles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindSeparateSamplers(NVNcommandBuffer *cmdBuf, NVNshaderStage stage, int first, int count, const NVNseparateSamplerHandle *samplerHandles)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDSEPARATESAMPLERSPROC)funcTable[422])(cmdBuf, stage, first, count, samplerHandles);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetStencilValueMask(NVNcommandBuffer *cmdBuf, NVNface faces, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSTENCILVALUEMASKPROC)funcTable[423])(cmdBuf, faces, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetStencilMask(NVNcommandBuffer *cmdBuf, NVNface faces, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSTENCILMASKPROC)funcTable[424])(cmdBuf, faces, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetStencilRef(NVNcommandBuffer *cmdBuf, NVNface faces, int ref)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSTENCILREFPROC)funcTable[425])(cmdBuf, faces, ref);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetBlendColor(NVNcommandBuffer *cmdBuf, const float *blendColor)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETBLENDCOLORPROC)funcTable[426])(cmdBuf, blendColor);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetPointSize(NVNcommandBuffer *cmdBuf, float pointSize)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETPOINTSIZEPROC)funcTable[427])(cmdBuf, pointSize);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetLineWidth(NVNcommandBuffer *cmdBuf, float lineWidth)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETLINEWIDTHPROC)funcTable[428])(cmdBuf, lineWidth);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetPolygonOffsetClamp(NVNcommandBuffer *cmdBuf, float factor, float units, float clamp)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETPOLYGONOFFSETCLAMPPROC)funcTable[429])(cmdBuf, factor, units, clamp);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetAlphaRef(NVNcommandBuffer *cmdBuf, float ref)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETALPHAREFPROC)funcTable[430])(cmdBuf, ref);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetSampleMask(NVNcommandBuffer *cmdBuf, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSAMPLEMASKPROC)funcTable[431])(cmdBuf, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetRasterizerDiscard(NVNcommandBuffer *cmdBuf, NVNboolean discard)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETRASTERIZERDISCARDPROC)funcTable[432])(cmdBuf, discard);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetDepthClamp(NVNcommandBuffer *cmdBuf, NVNboolean clamp)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETDEPTHCLAMPPROC)funcTable[433])(cmdBuf, clamp);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetConservativeRasterEnable(NVNcommandBuffer *cmdBuf, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCONSERVATIVERASTERENABLEPROC)funcTable[434])(cmdBuf, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetConservativeRasterDilate(NVNcommandBuffer *cmdBuf, float dilate)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCONSERVATIVERASTERDILATEPROC)funcTable[435])(cmdBuf, dilate);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetSubpixelPrecisionBias(NVNcommandBuffer *cmdBuf, int xBits, int yBits)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSUBPIXELPRECISIONBIASPROC)funcTable[436])(cmdBuf, xBits, yBits);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferCopyBufferToTexture(NVNcommandBuffer *cmdBuf, NVNbufferAddress src, const NVNtexture *dstTexture, const NVNtextureView *dstView, const NVNcopyRegion *dstRegion, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCOPYBUFFERTOTEXTUREPROC)funcTable[437])(cmdBuf, src, dstTexture, dstView, dstRegion, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferCopyTextureToBuffer(NVNcommandBuffer *cmdBuf, const NVNtexture *srcTexture, const NVNtextureView *srcView, const NVNcopyRegion *srcRegion, NVNbufferAddress dst, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCOPYTEXTURETOBUFFERPROC)funcTable[438])(cmdBuf, srcTexture, srcView, srcRegion, dst, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferCopyTextureToTexture(NVNcommandBuffer *cmdBuf, const NVNtexture *srcTexture, const NVNtextureView *srcView, const NVNcopyRegion *srcRegion, const NVNtexture *dstTexture, const NVNtextureView *dstView, const NVNcopyRegion *dstRegion, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCOPYTEXTURETOTEXTUREPROC)funcTable[439])(cmdBuf, srcTexture, srcView, srcRegion, dstTexture, dstView, dstRegion, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferCopyBufferToBuffer(NVNcommandBuffer *cmdBuf, NVNbufferAddress src, NVNbufferAddress dst, size_t size, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCOPYBUFFERTOBUFFERPROC)funcTable[440])(cmdBuf, src, dst, size, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearBuffer(NVNcommandBuffer *cmdBuf, NVNbufferAddress dst, size_t size, uint32_t value)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARBUFFERPROC)funcTable[441])(cmdBuf, dst, size, value);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearTexture(NVNcommandBuffer *cmdBuf, const NVNtexture *dstTexture, const NVNtextureView *dstView, const NVNcopyRegion *dstRegion, const float *color, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARTEXTUREPROC)funcTable[442])(cmdBuf, dstTexture, dstView, dstRegion, color, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearTexturei(NVNcommandBuffer *cmdBuf, const NVNtexture *dstTexture, const NVNtextureView *dstView, const NVNcopyRegion *dstRegion, const int *color, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARTEXTUREIPROC)funcTable[443])(cmdBuf, dstTexture, dstView, dstRegion, color, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferClearTextureui(NVNcommandBuffer *cmdBuf, const NVNtexture *dstTexture, const NVNtextureView *dstView, const NVNcopyRegion *dstRegion, const uint32_t *color, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERCLEARTEXTUREUIPROC)funcTable[444])(cmdBuf, dstTexture, dstView, dstRegion, color, mask);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferUpdateUniformBuffer(NVNcommandBuffer *cmdBuf, NVNbufferAddress buffer, size_t bufferSize, ptrdiff_t updateOffset, size_t updateSize, const void *data)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERUPDATEUNIFORMBUFFERPROC)funcTable[445])(cmdBuf, buffer, bufferSize, updateOffset, updateSize, data);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferReportCounter(NVNcommandBuffer *cmdBuf, NVNcounterType counter, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERREPORTCOUNTERPROC)funcTable[446])(cmdBuf, counter, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferResetCounter(NVNcommandBuffer *cmdBuf, NVNcounterType counter)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERRESETCOUNTERPROC)funcTable[447])(cmdBuf, counter);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferReportValue(NVNcommandBuffer *cmdBuf, uint32_t value, NVNbufferAddress buffer)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERREPORTVALUEPROC)funcTable[448])(cmdBuf, value, buffer);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetRenderEnable(NVNcommandBuffer *cmdBuf, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETRENDERENABLEPROC)funcTable[449])(cmdBuf, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetRenderEnableConditional(NVNcommandBuffer *cmdBuf, NVNconditionalRenderMode mode, NVNbufferAddress counters)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETRENDERENABLECONDITIONALPROC)funcTable[450])(cmdBuf, mode, counters);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetRenderTargets(NVNcommandBuffer *cmdBuf, int numColors, const NVNtexture * const *colors, const NVNtextureView * const *colorViews, const NVNtexture *depthStencil, const NVNtextureView *depthStencilView)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETRENDERTARGETSPROC)funcTable[451])(cmdBuf, numColors, colors, colorViews, depthStencil, depthStencilView);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDiscardColor(NVNcommandBuffer *cmdBuf, int index)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDISCARDCOLORPROC)funcTable[452])(cmdBuf, index);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDiscardDepthStencil(NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDISCARDDEPTHSTENCILPROC)funcTable[453])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDownsample(NVNcommandBuffer *cmdBuf, const NVNtexture *src, const NVNtexture *dst)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDOWNSAMPLEPROC)funcTable[454])(cmdBuf, src, dst);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferTiledDownsample(NVNcommandBuffer *cmdBuf, const NVNtexture *src, const NVNtexture *dst)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERTILEDDOWNSAMPLEPROC)funcTable[455])(cmdBuf, src, dst);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDownsampleTextureView(NVNcommandBuffer *cmdBuf, const NVNtexture *src, const NVNtextureView *srcView, const NVNtexture *dst, const NVNtextureView *dstView)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDOWNSAMPLETEXTUREVIEWPROC)funcTable[456])(cmdBuf, src, srcView, dst, dstView);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferTiledDownsampleTextureView(NVNcommandBuffer *cmdBuf, const NVNtexture *src, const NVNtextureView *srcView, const NVNtexture *dst, const NVNtextureView *dstView)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERTILEDDOWNSAMPLETEXTUREVIEWPROC)funcTable[457])(cmdBuf, src, srcView, dst, dstView);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBarrier(NVNcommandBuffer *cmdBuf, int barrier)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBARRIERPROC)funcTable[458])(cmdBuf, barrier);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferWaitSync(NVNcommandBuffer *cmdBuf, const NVNsync *sync)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERWAITSYNCPROC)funcTable[459])(cmdBuf, sync);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferFenceSync(NVNcommandBuffer *cmdBuf, NVNsync *sync, NVNsyncCondition condition, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERFENCESYNCPROC)funcTable[460])(cmdBuf, sync, condition, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetTexturePool(NVNcommandBuffer *cmdBuf, const NVNtexturePool *texturePool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETTEXTUREPOOLPROC)funcTable[461])(cmdBuf, texturePool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetSamplerPool(NVNcommandBuffer *cmdBuf, const NVNsamplerPool *samplerPool)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSAMPLERPOOLPROC)funcTable[462])(cmdBuf, samplerPool);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetShaderScratchMemory(NVNcommandBuffer *cmdBuf, const NVNmemoryPool *pool, ptrdiff_t offset, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSHADERSCRATCHMEMORYPROC)funcTable[463])(cmdBuf, pool, offset, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSaveZCullData(NVNcommandBuffer *cmdBuf, NVNbufferAddress dst, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSAVEZCULLDATAPROC)funcTable[464])(cmdBuf, dst, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferRestoreZCullData(NVNcommandBuffer *cmdBuf, NVNbufferAddress src, size_t size)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERRESTOREZCULLDATAPROC)funcTable[465])(cmdBuf, src, size);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetCopyRowStride(NVNcommandBuffer *cmdBuf, ptrdiff_t stride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCOPYROWSTRIDEPROC)funcTable[466])(cmdBuf, stride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetCopyImageStride(NVNcommandBuffer *cmdBuf, ptrdiff_t stride)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCOPYIMAGESTRIDEPROC)funcTable[467])(cmdBuf, stride);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnCommandBufferGetCopyRowStride(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCOPYROWSTRIDEPROC)funcTable[468])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) ptrdiff_t nvnCommandBufferGetCopyImageStride(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETCOPYIMAGESTRIDEPROC)funcTable[469])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferDrawTexture(NVNcommandBuffer *cmdBuf, NVNtextureHandle texture, const NVNdrawTextureRegion *dstRegion, const NVNdrawTextureRegion *srcRegion)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERDRAWTEXTUREPROC)funcTable[470])(cmdBuf, texture, dstRegion, srcRegion);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnProgramSetSubroutineLinkage(NVNprogram *program, int count, const NVNsubroutineLinkageMapPtr *linkageMapPtrs)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNPROGRAMSETSUBROUTINELINKAGEPROC)funcTable[471])(program, count, linkageMapPtrs);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetProgramSubroutines(NVNcommandBuffer *cmdBuf, NVNprogram *program, NVNshaderStage stage, const int first, const int count, const int *values)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETPROGRAMSUBROUTINESPROC)funcTable[472])(cmdBuf, program, stage, first, count, values);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferBindCoverageModulationTable(NVNcommandBuffer *cmdBuf, const float *entries)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERBINDCOVERAGEMODULATIONTABLEPROC)funcTable[473])(cmdBuf, entries);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferResolveDepthBuffer(NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERRESOLVEDEPTHBUFFERPROC)funcTable[474])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetColorReductionEnable(NVNcommandBuffer *cmdBuf, NVNboolean enable)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCOLORREDUCTIONENABLEPROC)funcTable[475])(cmdBuf, enable);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetColorReductionThresholds(NVNcommandBuffer *cmdBuf, NVNformatClass formatClass, int thresholdConservative, int thresholdAggressive)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETCOLORREDUCTIONTHRESHOLDSPROC)funcTable[476])(cmdBuf, formatClass, thresholdConservative, thresholdAggressive);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferPushDebugGroupStatic(NVNcommandBuffer *cmdBuf, uint32_t domainId, const char * description)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERPUSHDEBUGGROUPSTATICPROC)funcTable[477])(cmdBuf, domainId, description);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferPushDebugGroupDynamic(NVNcommandBuffer *cmdBuf, uint32_t domainId, const char * description)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERPUSHDEBUGGROUPDYNAMICPROC)funcTable[478])(cmdBuf, domainId, description);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferPushDebugGroup(NVNcommandBuffer *cmdBuf, const char * description)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERPUSHDEBUGGROUPPROC)funcTable[479])(cmdBuf, description);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferPopDebugGroup(NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERPOPDEBUGGROUPPROC)funcTable[480])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferPopDebugGroupId(NVNcommandBuffer *cmdBuf, uint32_t domainId)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERPOPDEBUGGROUPIDPROC)funcTable[481])(cmdBuf, domainId);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferInsertDebugMarkerStatic(NVNcommandBuffer *cmdBuf, uint32_t domainId, const char * description)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERINSERTDEBUGMARKERSTATICPROC)funcTable[482])(cmdBuf, domainId, description);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferInsertDebugMarkerDynamic(NVNcommandBuffer *cmdBuf, uint32_t domainId, const char * description)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERINSERTDEBUGMARKERDYNAMICPROC)funcTable[483])(cmdBuf, domainId, description);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferInsertDebugMarker(NVNcommandBuffer *cmdBuf, const char * description)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERINSERTDEBUGMARKERPROC)funcTable[484])(cmdBuf, description);
}

NN_NOINLINE __attribute__((disable_tail_calls)) PFNNVNCOMMANDBUFFERMEMORYCALLBACKPROC nvnCommandBufferGetMemoryCallback(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETMEMORYCALLBACKPROC)funcTable[485])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void* nvnCommandBufferGetMemoryCallbackData(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERGETMEMORYCALLBACKDATAPROC)funcTable[486])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnCommandBufferIsRecording(const NVNcommandBuffer *cmdBuf)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNCOMMANDBUFFERISRECORDINGPROC)funcTable[487])(cmdBuf);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnSyncInitialize(NVNsync *sync, NVNdevice *device)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSYNCINITIALIZEPROC)funcTable[488])(sync, device);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSyncFinalize(NVNsync *sync)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSYNCFINALIZEPROC)funcTable[489])(sync);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnSyncSetDebugLabel(NVNsync *sync, const char * label)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNSYNCSETDEBUGLABELPROC)funcTable[490])(sync, label);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnQueueFenceSync(NVNqueue *queue, NVNsync *sync, NVNsyncCondition condition, int flags)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNQUEUEFENCESYNCPROC)funcTable[491])(queue, sync, condition, flags);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNsyncWaitResult nvnSyncWait(const NVNsync *sync, uint64_t timeoutNs)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSYNCWAITPROC)funcTable[492])(sync, timeoutNs);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnQueueWaitSync(NVNqueue *queue, const NVNsync *sync)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNQUEUEWAITSYNCPROC)funcTable[493])(queue, sync);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnSyncInitializeFromFencedGLSync(NVNsync *sync, NVNdevice *device, const void *glSync, NVNsyncInteropStatus *status)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSYNCINITIALIZEFROMFENCEDGLSYNCPROC)funcTable[494])(sync, device, glSync, status);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNsyncInteropStatus nvnSyncCreateGLSync(const NVNsync *sync, uint64_t *glSync)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNSYNCCREATEGLSYNCPROC)funcTable[495])(sync, glSync);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnEventBuilderSetDefaults(NVNeventBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNEVENTBUILDERSETDEFAULTSPROC)funcTable[496])(builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnEventBuilderSetStorage(NVNeventBuilder *builder, const NVNmemoryPool *pool, int64_t offset)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNEVENTBUILDERSETSTORAGEPROC)funcTable[497])(builder, pool, offset);
}

NN_NOINLINE __attribute__((disable_tail_calls)) const NVNmemoryPool * nvnEventBuilderGetStorage(const NVNeventBuilder *builder, int64_t *offset)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNEVENTBUILDERGETSTORAGEPROC)funcTable[498])(builder, offset);
}

NN_NOINLINE __attribute__((disable_tail_calls)) NVNboolean nvnEventInitialize(NVNevent *event, const NVNeventBuilder *builder)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNEVENTINITIALIZEPROC)funcTable[499])(event, builder);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnEventFinalize(NVNevent *event)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNEVENTFINALIZEPROC)funcTable[500])(event);
}

NN_NOINLINE __attribute__((disable_tail_calls)) uint32_t nvnEventGetValue(const NVNevent *event)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    return ((PFNNVNEVENTGETVALUEPROC)funcTable[501])(event);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnEventSignal(NVNevent *event, NVNeventSignalMode mode, uint32_t value)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNEVENTSIGNALPROC)funcTable[502])(event, mode, value);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferWaitEvent(NVNcommandBuffer *cmdBuf, const NVNevent *event, NVNeventWaitMode waitMode, uint32_t value)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERWAITEVENTPROC)funcTable[503])(cmdBuf, event, waitMode, value);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSignalEvent(NVNcommandBuffer *cmdBuf, const NVNevent *event, NVNeventSignalMode mode, NVNeventSignalLocation location, int flags, uint32_t value)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSIGNALEVENTPROC)funcTable[504])(cmdBuf, event, mode, location, flags, value);
}

NN_NOINLINE __attribute__((disable_tail_calls)) void nvnCommandBufferSetStencilCullCriteria(NVNcommandBuffer *cmdBuf, NVNstencilFunc func, int ref, int mask)
{
    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);
    ((PFNNVNCOMMANDBUFFERSETSTENCILCULLCRITERIAPROC)funcTable[505])(cmdBuf, func, ref, mask);
}



static_assert(NvnFunctionCount == 506, "nvnFunctionCount should equal funcIndex");
}}} // nn::profiler::nvn
#ifdef __cplusplus
} // extern "C"
#endif
