#/*--------------------------------------------------------------------------------*
#  Copyright (C)Nintendo All rights reserved.
#
#  These coded instructions, statements, and computer programs contain proprietary
#  information of Nintendo and/or its licensed developers and are protected by
#  national and international copyright laws. They may not be disclosed to third
#  parties or copied or duplicated in any form, in whole or in part, without the
#  prior written consent of Nintendo.
#
#  The content herein is highly confidential and should be handled accordingly.
# *--------------------------------------------------------------------------------*/

param (
    [Parameter(Mandatory=$true)][string]$OutputPath,
    [string]$SdkRoot = $ENV:NINTENDO_SDK_ROOT
)

$nvnSrcFolder = "$SdkRoot/Externals/odin2/common-headers/nvn/nvn"
if ($false -eq (test-path $nvnSrcFolder))
{
    write-error "Could not find NVN Src Folder: $nvnSrcFolder"
}

$outputLocation = $OutputPath | resolve-path


function Append-File
{
    param(
        [string]$Path,
        $InputObject
    )
    $InputObject | out-file $Path -Append -Encoding "UTF8"
}


if ($false -eq (test-path $outputLocation))
{
    mkdir $outputLocation
}

$nvnPtrInline = "$nvnSrcFolder/nvn_FuncPtrInline.h"
$nvnPtrImpl = "$nvnSrcFolder/nvn_FuncPtrImpl.h"
$nvnWrappers = "$outputLocation/profiler_NvnWrappers.autogen.cpp"

[regex]$searchFuncNames = [regex]'.*=.*\"(.*)\"'
[string[]]$funcNames = @()
$fileContents = [string[]](get-content $nvnPtrImpl)
foreach ($line in $fileContents)
{
    $match = $searchFuncNames.Match($line)
    if ($match.Success)
    {
        # Leading ',' enforces treating this as an array
        #   (not needed with initialization, but here to be safe)
        $funcNames += ,$match.Groups[1].Value
    }
}


[regex]$searchFuncNames = [regex]'^(static.*\s([A-Za-z_][0-9A-Za-z_]*)\(.*\))'
[string[]]$verifyFuncNames = @()
$fileContents = [string[]](get-content $nvnPtrInline)
foreach ($line in $fileContents)
{
    $match = $searchFuncNames.Match($line)
    if ($match.Success)
    {
        # Leading ',' enforces treating this as an array
        #   (not needed with initialization, but here to be safe)
        $verifyFuncNames += ,$match.Groups[2].Value
    }
}


$funcListIdentical = $false
if ($funcNames.Count -eq $verifyFuncNames.Count)
{
    $funcListIdentical = $true
    for ($i = 0; ($i -lt $funcNames.Count) -and ($funcListIdentical); ++$i)
    {
        if ($funcNames[$i] -ne $verifyFuncNames[$i])
        {
            [string]$message = $funcNames[$i] + " != " + $verifyFuncNames[$i]
            write-output $message
            $funcListIdentical = $false
        }
    }
}
else
{
    [string]$message = "Different number of functions! " + $funcNames.Count + " vs "  +$verifyFuncNames.Count
    write-output $message
}
if ($funcListIdentical -eq $false)
{
    write-error "Function list in $nvnPtrImpl != $nvnPtrInline"
    exit 1
}


$nvnFunctionCount = $funcNames.Count
[regex]$findFuncPtrs = [regex]'^(.*)\bpfnc_([A-Za-z_][A-Za-z0-9_]*)(.*)'
[int]$funcIndex = 0

[string]$copyrightNotice = 
"/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
// This file was automatically generated. Do not modify it directly."


$copyrightNotice | out-file $nvnWrappers -Encoding "UTF8"

[string]$outputLine = ""
append-file $nvnWrappers '#include <nvn/nvn.h>'
append-file $nvnWrappers '#include <nvn/nvn_FuncPtr.h>'
append-file $nvnWrappers '#include "profiler_nvn.h"'
append-file $nvnWrappers '#ifdef __cplusplus'
append-file $nvnWrappers 'extern "C" {'
append-file $nvnWrappers '#endif'
append-file $nvnWrappers "const size_t NvnFunctionCount = $nvnFunctionCount;"
append-file $nvnWrappers 'namespace nn { namespace profiler {'
append-file $nvnWrappers 'extern char *gNvnFuncTable;'
append-file $nvnWrappers 'namespace nvn {'
foreach ($line in $fileContents)
{
    if (($line -match "(^///)|(^#)") -or
        ($line -match '^extern "C" {$') -or
        ($line -match '^} // extern "C"$'))
    {
        continue
    }
    elseif ($line -match '^{')
    {
        $funcName = $funcNames[$funcIndex]
        $output = $line
        #$output += [Environment]::NewLine + "    ::nn::profiler::ScopedCodeBlock block(`"$funcName`");"
    }
    else
    {
        $temp = $line -replace 'NVNINLINE', 'NN_NOINLINE __attribute__((disable_tail_calls))'
        $temp = $temp -replace 'static ', ''
        $match = $findFuncPtrs.Match($temp)
        if ($match.Success)
        {
            $ptrType = "PFN" + $match.Groups[2].Value.ToUpper() + "PROC"
            $output = '    const uintptr_t *funcTable = reinterpret_cast<uintptr_t*>(gNvnFuncTable + NvnFunctionPointersTableHeaderSize);'
            $output += [Environment]::NewLine
            $output += $match.Groups[1].Value + "(($ptrType)funcTable[$funcIndex])" + $match.Groups[3].Value
            ++$funcIndex
        }
        else
        {
            $output = $temp
        }
    }
    append-file $nvnWrappers $output
}
append-file $nvnWrappers "static_assert(NvnFunctionCount == $funcIndex, `"nvnFunctionCount should equal funcIndex`");"
append-file $nvnWrappers '}}} // nn::profiler::nvn'
append-file $nvnWrappers '#ifdef __cplusplus'
append-file $nvnWrappers '} // extern "C"'
append-file $nvnWrappers '#endif'

exit $LASTEXITCODE
