﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/profiler/profiler_Api.h>

#include "profiler_LibPrivate.h"
#include "profiler_ResultPrivate.h"
#include "profiler_Vsync.h"

#include "profiler_Defines.h"

namespace nn { namespace profiler {

void DisableGraphicsFeatures()
{
    // This currently does no work and does not disable anything.
}

nn::Result EnableGraphicsFeatures()
{
    if (GetProfilerStatus() != ProfilerStatus_Offline)
    {
        // This currently does no work and does not enable anything,
        // but in the future it will likely enable NVN tracing.
        return nn::ResultSuccess();
    }
    else
    {
        return nn::profiler::ResultNotInitialized();
    }
}

} // profiler
} // nn
