﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/prepo_ApiDebug.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/detail/prepo_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace prepo {

nn::Result GetStorageUsage(int64_t* outUsed, int64_t* outCapacity) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUsed);
    NN_SDK_REQUIRES_NOT_NULL(outCapacity);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_RESULT_DO(session->GetStorageUsage(outUsed, outCapacity));

    NN_RESULT_SUCCESS;
}

void GetStatistics(Statistics* out) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(out);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_ABORT_UNLESS_RESULT_SUCCESS(session->GetStatistics(out));
}

void GetThroughputHistory(int* outCount, ThroughputRecord* outArray, int arrayCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outArray);
    NN_SDK_REQUIRES_GREATER(arrayCount, 0);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_ABORT_UNLESS_RESULT_SUCCESS(session->GetThroughputHistory(outCount, nn::sf::OutArray<ThroughputRecord>(outArray, arrayCount)));
}

nn::Result GetLastUploadError() NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    return session->GetLastUploadError();
}

}}
