﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/prepo_ApiAdmin.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/detail/prepo_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace prepo {

nn::Result ClearStorage() NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_RESULT_DO(session->ClearStorage());

    NN_RESULT_SUCCESS;
}

nn::Result ClearStatistics() NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_RESULT_DO(session->ClearStatistics());

    NN_RESULT_SUCCESS;
}

void SetOperationMode(int64_t mode) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_ABORT_UNLESS_RESULT_SUCCESS(session->SetOperationMode(mode));
}

}}
