﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/prepo_PrepoService.generic.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/prepo_Types.h>

namespace nn { namespace prepo { namespace detail { namespace service {

PrepoServiceForGeneric::PrepoServiceForGeneric() NN_NOEXCEPT
{
}

PrepoServiceForGeneric::~PrepoServiceForGeneric() NN_NOEXCEPT
{
}

nn::Result PrepoServiceForGeneric::SaveReport(const nn::sf::InArray<char>& eventId, const nn::sf::InBuffer& data, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(eventId);
    NN_UNUSED(data);
    NN_UNUSED(processId);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::SaveReportWithUser(const nn::account::Uid& uid,
    const nn::sf::InArray<char>& eventId, const nn::sf::InBuffer& data, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(eventId);
    NN_UNUSED(data);
    NN_UNUSED(processId);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::RequestImmediateTransmission() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::GetTransmissionStatus(nn::sf::Out<std::int32_t> outStatus) NN_NOEXCEPT
{
    *outStatus = TransmissionStatus_Idle;

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::SaveSystemReport(const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT
{
    NN_UNUSED(eventId);
    NN_UNUSED(appId);
    NN_UNUSED(data);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::SaveSystemReportWithUser(const nn::account::Uid& uid,
    const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT
{
    NN_UNUSED(uid);
    NN_UNUSED(eventId);
    NN_UNUSED(appId);
    NN_UNUSED(data);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::SetOperationMode(std::int64_t mode) NN_NOEXCEPT
{
    NN_UNUSED(mode);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::ClearStorage() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::ClearStatistics() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::IsUserAgreementCheckEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
{
    *outIsEnabled = true;

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::SetUserAgreementCheckEnabled(bool isEnabled) NN_NOEXCEPT
{
    NN_UNUSED(isEnabled);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::GetStorageUsage(nn::sf::Out<std::int64_t> outUsed, nn::sf::Out<std::int64_t> outCapacity) NN_NOEXCEPT
{
    *outUsed = 0;
    *outCapacity = 0;

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::GetStatistics(nn::sf::Out<nn::prepo::Statistics> outStatistics) NN_NOEXCEPT
{
    NN_UNUSED(outStatistics);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::GetThroughputHistory(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<ThroughputRecord>& outArray) NN_NOEXCEPT
{
    NN_UNUSED(outCount);
    NN_UNUSED(outArray);

    NN_RESULT_SUCCESS;
}

nn::Result PrepoServiceForGeneric::GetLastUploadError() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

}}}}
