﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/core/prepo_CategoryObject.h>
#include <nn/prepo/detail/service/core/prepo_StatisticsManager.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

CategoryObject::CategoryObject(const char* mountName, bool isUserAgreementCheckRequired) NN_NOEXCEPT
    : m_ReportFileManager(mountName, isUserAgreementCheckRequired)
{
    m_UploadExecuter.RegisterReportFileManager(&m_ReportFileManager);
}

ReportFileManager& CategoryObject::GetReportFileManager(ReportCategory category) NN_NOEXCEPT
{
    return GetObject(category).m_ReportFileManager;
}

UploadExecuter& CategoryObject::GetUploadExecuter(ReportCategory category) NN_NOEXCEPT
{
    return GetObject(category).m_UploadExecuter;
}

nn::Result CategoryObject::ExecuteUpload(bool isImmediate) NN_NOEXCEPT
{
    for (int i = 0; i < ReportCategory_Count; i++)
    {
        const auto category = static_cast<ReportCategory>(i);

        ReportDataSummary summary;
        NN_RESULT_TRY(GetUploadExecuter(category).Execute(&summary, g_ReportBuffer, sizeof (g_ReportBuffer), isImmediate))
            NN_RESULT_CATCH(ResultTransmissionNotAgreed)
            {
            }
        NN_RESULT_END_TRY;

        if (summary.restCount > 0)
        {
            StatisticsManager::GetInstance().AddUploaded(category, summary.restSize, summary.restCount);
        }

        if (summary.deletedCount > 0)
        {
            StatisticsManager::GetInstance().AddLostByDisagree(category, summary.deletedSize, summary.deletedCount);
        }
    }
    NN_RESULT_SUCCESS;
}

CategoryObject& CategoryObject::GetObject(ReportCategory category) NN_NOEXCEPT
{
    NN_SDK_ASSERT_RANGE(category, 0, ReportCategory_Count);
    NN_FUNCTION_LOCAL_STATIC(CategoryObject, s_Array, [] =
    {
        // マウント名   同意チェックが必要か
        {"prepo",       true},  // 通常のレポート
        {"prepo-ap",    false}  // 海賊版対策のレポート
    });
    NN_STATIC_ASSERT(NN_ARRAY_SIZE(s_Array) == ReportCategory_Count);
    return s_Array[category];
}

nn::Bit8 CategoryObject::g_ReportBuffer[ReportFileSizeMax];

}}}}}
