﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "perflog_CreateDaemon.h"
#include "perflog_DaemonImpl.h"
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace perflog {

namespace {

// Implement the DaemonImpl implementation class so that it can be accessed as an IDaemon service object.
// Use nn::sf::UnmanagedServiceObject.
// Specify the interface name in the first template parameter and the implementation for the interface in the second parameter.
// The IDaemon interface is mapped to the DaemonImpl implementation in the nn::sf::UnmanagedServiceObject to enable access to features via the service object.
nn::sf::UnmanagedServiceObject<sf::IDaemon, DaemonImpl> g_Daemon;

}

// A shared pointer is used to access the features.
// Create a function that returns a shared pointer, which can then be used by service users to access the features.
nn::sf::SharedPointer<sf::IDaemon> CreateDaemonByDfc() NN_NOEXCEPT
{
    // When using nn::sf::UnmanagedServiceObject, the GetShared member function can be used to get a shared pointer.
    return g_Daemon.GetShared();
}

}}  // nn::perflog
