﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/pcv/driver/detail/pcv_ModuleNames.h>

namespace nn { namespace pcv { namespace driver { namespace detail {

const char* UnknownModule = "Module_Unknown";

const char* GetModuleName(Module module) NN_NOEXCEPT
{
    for ( auto& info : ModuleNames )
    {
        if ( module == info.module )
        {
            return info.name;
        }
    }

    return UnknownModule;
}

}}}} //namespace nn::pcv::driver::detail
