﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>

#include <nn/nn_Common.h>

#include <nn/spl/spl_Types.h>

#include <nne/vcc/vcc_dram_ids.h>

namespace {

const std::pair<nn::spl::DramId, nne::vcc::DramId> SplDramIdVccDramIdPairs[] =
{
    { nn::spl::DramId_IcosaSamsung2g,  nne::vcc::DramId_Samsung4gb01 },
    { nn::spl::DramId_IcosaSamsung3g,  nne::vcc::DramId_Samsung6gb01 },
    { nn::spl::DramId_IcosaHynix,      nne::vcc::DramId_Hynix4gb01 },
    { nn::spl::DramId_IcosaMicron,     nne::vcc::DramId_Micron4gb01 },

    //{ nn::spl::DramId_CopperSamsung2g, nne::vcc::DramId_Samsung4gb01 },
    //{ nn::spl::DramId_CopperHynix,     nne::vcc::DramId_Hynix4gb01 },
    //{ nn::spl::DramId_CopperMicron,    nne::vcc::DramId_Micron4gb01 },

    { nn::spl::DramId_IowaSamsung2g,   nne::vcc::DramId_Samsung4gb01 },

    { nn::spl::DramId_IowaX3Samsung2g, nne::vcc::DramId_Samsung4gb03 },
    { nn::spl::DramId_IowaX3Samsung4g, nne::vcc::DramId_Samsung8gb03 },
    //{ nn::spl::DramId_IowaX3Hynix,      },
    //{ nn::spl::DramId_IowaX3Micron,     },

    { nn::spl::DramId_HoagSamsung2g,   nne::vcc::DramId_Samsung4gb03 },
    { nn::spl::DramId_HoagSamsung4g,   nne::vcc::DramId_Samsung8gb03 },
    //{ nn::spl::DramId_IowaX3Hynix,      },
    //{ nn::spl::DramId_IowaX3Micron,     },
};

} // namespace
