﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pcv/detail/pcv_Log.h>
#include <nn/pcv/driver/detail/pcv_ExpectedDefaultStates.h>
#include <nn/pcv/pcv.h>
#include <nn/result/result_HandlingUtility.h>

#include "pcv_Driver.h"
#include "pcv_GetModuleName.h"

namespace nn { namespace pcv { namespace driver { namespace detail {

bool AreDefaultStatesExpected() NN_NOEXCEPT
{
    bool expected = true;

    for ( auto& info : ExpectedDefaultStates )
    {
        nn::pcv::ModuleState state;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::pcv::driver::detail::GetState(&state, info.module));

        // Check clock gating and dump messages.
        if ( info.clockEnabled != state.clockEnabled )
        {
            NN_DETAIL_PCV_WARN("%s clock is %s(should be %s).\n",
                GetModuleName(info.module),
                state.clockEnabled ? "enabled" : "disabled",
                info.clockEnabled ? "enabled" : "disabled");
            expected = false;
        }
    }

    return expected;
}

}}}} // namespace nn::pcv::driver::detail
