﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>
#include <nn/pctl/pctl_ApiSettings.h>
#include <nn/pctl/pctl_TypesSystem.h>
#include <nn/pctl/detail/pctl_ResultHandler.h>
#include <nn/pctl/detail/ipc/pctl_IpcSession.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl {

// ペアレンタルコントロール設定取得関数

bool IsRestrictionEnabled() NN_NOEXCEPT
{
    bool value = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetService()->IsRestrictionEnabled(&value));
    return value;
}

SafetyLevel GetSafetyLevel() NN_NOEXCEPT
{
    int value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetService()->GetSafetyLevel(&value));
    return static_cast<SafetyLevel>(value);
}

void GetCurrentSettings(RestrictionSettings* pSettings) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pSettings);

    NN_STATIC_ASSERT((std::is_same<RestrictionSettings, SafetyLevelSettings>::value));
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetService()->GetCurrentSettings(pSettings));
}

}}
