﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/pctl_RetrieveOwners.h>

#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/detail/pctl_Log.h>
#include <nn/pctl/detail/service/pctl_ServiceConfig.h>
#include <nn/pctl/detail/service/pctl_ServiceWatcher.h>
#include <nn/pctl/detail/service/watcher/pctl_Authentication.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherErrorHandler.h>
#include <nn/pctl/detail/service/watcher/dispatcher/pctl_RetrieveOwnersDispatcher.h>

#include <nn/result/result_HandlingUtility.h>

#include <nn/util/util_FormatString.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

nn::Result RetrieveDeviceOwnersExecutor::Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT
{
    TokenHolder tokenHolder;
    NN_RESULT_DO(g_pWatcher->GetNetworkManager().AcquireAuthenticationToken(tokenHolder, bufferInfo, m_pCancelable));

    NN_RESULT_DO(
        dispatcher::RetrieveDeviceOwnersDispatcher::Execute(m_ActualOwnerCountPointer, m_pOwners, m_MaxOwnerCount,
            bufferInfo, m_pCancelable, tokenHolder.GetToken(), m_DeviceId)
        );

    NN_RESULT_SUCCESS;
}

void RetrieveDeviceOwnersExecutor::Cancel() NN_NOEXCEPT
{
    if (m_pCancelable != nullptr)
    {
        m_pCancelable->Cancel();
    }
}

}}}}}
