﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/pctl_Notifications.h>

#include <nn/npns/npns_Api.h>
#include <nn/npns/npns_ApiSystem.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/detail/pctl_Log.h>
#include <nn/pctl/detail/pctl_NpnsErrorHandler.h>
#include <nn/pctl/detail/service/pctl_ServiceConfig.h>
#include <nn/pctl/detail/service/pctl_ServiceWatcher.h>

#include <nn/result/result_HandlingUtility.h>

#include <nn/util/util_ScopeExit.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

nn::Result CreateNotificationToken::Execute(nn::npns::NotificationToken& outToken, common::Cancelable* pCancelable) NN_NOEXCEPT
{
    NN_UNUSED(pCancelable);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_RESULT_DO(ConvertNpnsError(nn::npns::CreateToken(&outToken, nn::account::InvalidUid, ApplicationIdPctl)));

    NN_RESULT_SUCCESS;
#else
    // MOON-2002 が修正された際は削除
    char data[40] = {
        0x39, 0x65, 0x38, 0x62, 0x35, 0x36, 0x66, 0x62, 0x30, 0x61, 0x61, 0x31,
        0x32, 0x61, 0x66, 0x34, 0x61, 0x38, 0x32, 0x38, 0x39, 0x62, 0x63, 0x33,
        0x64, 0x61, 0x35, 0x62, 0x31, 0x36, 0x31, 0x62, 0x30, 0x63, 0x62, 0x36,
        0x00, 0x00, 0x00, 0x00
    };
    std::memcpy(outToken.data, data, sizeof(outToken.data));
    // 何もせず Success とする
    NN_RESULT_SUCCESS;
#endif
}

////////////////////////////////////////////////////////////////////////////////

nn::Result CreateNotificationTokenExecutor::Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT
{
    NN_UNUSED(bufferInfo);

    NN_RESULT_DO(
        CreateNotificationToken::Execute(m_Token, m_pCancelable)
    );

    g_pWatcher->GetNetworkManager().StoreNotificationToken(m_Token);

    NN_RESULT_SUCCESS;
}

void CreateNotificationTokenExecutor::Cancel() NN_NOEXCEPT
{
    if (m_pCancelable != nullptr)
    {
        m_pCancelable->Cancel();
    }
}

}}}}}
