﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/system/pctl_SettingsManager.h>

#include <nn/os/os_ThreadApi.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace system {

void SettingsManager::InitializeForMasterKey() NN_NOEXCEPT
{
    // Win版では基本的に何もしない
    m_DataForMasterKeyInquiry = 0; // このデータも用いられない
}

void SettingsManager::GenerateInquiryCode(InquiryCode* outCode) NN_NOEXCEPT
{
    // 暫定実装として固定値を返す
    std::strncpy(outCode->codeString, "1234560000", 10);
    outCode->codeString[10] = 0;
    std::memset(outCode->_reserved, 0xCC, sizeof(outCode->_reserved));
    outCode->_reserved[0] = 0;
}

bool SettingsManager::CheckMasterKey(const InquiryCode& codeData, const char* masterKey, size_t masterKeyLength) NN_NOEXCEPT
{
    // 1秒ウェイトを入れる
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));

    // 暫定実装として codeData.codeString と masterKey それぞれの先頭6文字が一致するかどうかを返す
    // ※ masterKeyLength はNULL文字込みの長さ
    return (masterKeyLength >= 7 && std::strncmp(codeData.codeString, masterKey, 6) == 0);
}

void SettingsManager::OnChangedPinCode() NN_NOEXCEPT
{
    // Win版では何もしない
}

}}}}}
