﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/pctl/detail/service/pctl_ServiceMemoryManagement.h>

#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS != NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_DFC
#error Unexpected configuration (DFC mode is expected for win32)
#endif

namespace nn { namespace pctl { namespace detail { namespace service {

namespace
{
    // Win版では必要な量は少ないはずなので制限を厳しくする
    NN_ALIGNAS(4096) nn::Bit8 g_Heap[128 * 1024];
    nn::mem::StandardAllocator g_Allocator;
}

void InitializeAllocatorForServer() NN_NOEXCEPT
{
    g_Allocator.Initialize(g_Heap, sizeof(g_Heap));
}

void* AllocateMemoryBlock(size_t size) NN_NOEXCEPT
{
    return g_Allocator.Allocate(size);
}

void* AllocateMemoryBlock(size_t size, size_t alignment) NN_NOEXCEPT
{
    return g_Allocator.Allocate(size, alignment);
}

void FreeMemoryBlock(void* block) NN_NOEXCEPT
{
    g_Allocator.Free(block);
}

}}}}
