﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/pctl/detail/service/pctl_ParentalControlServiceImpl.h>
#include <nn/pctl/detail/service/pctl_ParentalControlServiceFactoryImpl.h>
#include <nn/pctl/detail/service/pctl_ServiceFactory.h>
#include <nn/sf/sf_ObjectFactory.h>

#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS == NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC

namespace nn { namespace pctl { namespace detail { namespace service {

namespace
{
    static const size_t SessionSize = ParentalControlServiceFactoryImpl::SessionSize;
    // 全セッションでサービスインスタンスを1つずつ作成できるようにするためのヒープサイズ
    static const size_t SessionHeapSize = ipc::SessionCountMax * SessionSize;

    std::aligned_storage<SessionHeapSize>::type g_HeapBuffer;
    nn::sf::ExpHeapAllocator g_Allocator;
    nn::lmem::HeapHandle g_HeapHandle;
    bool g_HeapInitialized = false;

    typedef nn::sf::UnmanagedServiceObject<ipc::IParentalControlServiceFactory,
        ParentalControlServiceFactoryImpl> ParentalControlServiceFactoryObject;

    std::aligned_storage<sizeof(ParentalControlServiceFactoryObject)>::type g_Storages[ipc::ServiceIndex_Count];
    ParentalControlServiceFactoryObject* g_Objects[ipc::ServiceIndex_Count] = {};

    static void InitializeFactoryAllocator() NN_NOEXCEPT
    {
        if (g_HeapInitialized)
        {
            return;
        }
        g_HeapHandle = nn::lmem::CreateExpHeap(&g_HeapBuffer, sizeof(g_HeapBuffer), nn::lmem::CreationOption_ThreadSafe);
        g_Allocator.Attach(g_HeapHandle);
        g_HeapInitialized = true;
    }
}

void InitializeFactory(ipc::ServiceIndex index, int capability) NN_NOEXCEPT
{
    InitializeFactoryAllocator();
    g_Objects[index] = new(&g_Storages[index]) ParentalControlServiceFactoryObject(&g_Allocator, capability);
}

void FinalizeAllFactories() NN_NOEXCEPT
{
    for (int i = 0; i < ipc::ServiceIndex_Count; ++i)
    {
        if (g_Objects[i] != nullptr)
        {
            g_Objects[i]->~ParentalControlServiceFactoryObject();
            g_Objects[i] = nullptr;
        }
    }
    g_Allocator.Detach();
    nn::lmem::DestroyExpHeap(g_HeapHandle);
    g_HeapInitialized = false;
}

nn::sf::SharedPointer<ipc::IParentalControlServiceFactory> GetFactory(ipc::ServiceIndex index) NN_NOEXCEPT
{
    return g_Objects[index]->GetShared();
}

}}}}

#endif
