﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/overlay/pctl_OverlaySender.h>

#include <nn/pctl/detail/service/pctl_ServiceWatcher.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace overlay {

// ターゲット別の処理を行う関数の定義
nn::Result NotifySettingChangedImpl(nn::ovln::format::PctlSettingTypeFlagSet settingType) NN_NOEXCEPT;
nn::Result NotifyPlayTimerRemainingTimeImpl(int16_t remainingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT;
nn::Result NotifyUnlinkImpl(nn::ovln::format::PctlUnlinkReasonFlag reason) NN_NOEXCEPT;
nn::Result NotifyTimeExceededOnStartImpl(int64_t exceedingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT;
nn::Result NotifyAlarmSettingChangedImpl(nn::ovln::format::PctlAlarmSettingFlag flag) NN_NOEXCEPT;

namespace
{
    bool g_IsOverlayNotificationDisabled = false;
}

void DisableOverlayNotification() NN_NOEXCEPT
{
    g_IsOverlayNotificationDisabled = true;
}

void EnableOverlayNotification() NN_NOEXCEPT
{
    g_IsOverlayNotificationDisabled = false;
}

nn::Result NotifySettingChanged(nn::ovln::format::PctlSettingTypeFlagSet settingType) NN_NOEXCEPT
{
    // MinimumAwakeMode のときは通知を遅延発行する
    if (g_IsOverlayNotificationDisabled)
    {
        if (IsWatcherAvailable())
        {
            g_pWatcher->GetNetworkManager().SetNotifyNecessaryFlagForSettingChanged(settingType);
        }
        return nn::ResultSuccess();
    }
    return NotifySettingChangedImpl(settingType);
}

nn::Result NotifyPlayTimerRemainingTime(int16_t remainingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT
{
    return NotifyPlayTimerRemainingTimeImpl(remainingTime, mode);
}

nn::Result NotifyUnlink(nn::ovln::format::PctlUnlinkReasonFlag reason) NN_NOEXCEPT
{
    // MinimumAwakeMode のときは通知を遅延発行する
    if (g_IsOverlayNotificationDisabled)
    {
        if (IsWatcherAvailable())
        {
            g_pWatcher->GetNetworkManager().SetNotifyNecessaryFlagForUnlinked(reason);
        }
        return nn::ResultSuccess();
    }
    return NotifyUnlinkImpl(reason);
}

nn::Result NotifyTimeExceededOnStart(int64_t exceedingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT
{
    return NotifyTimeExceededOnStartImpl(exceedingTime, mode);
}

nn::Result NotifyAlarmSettingChanged(nn::ovln::format::PctlAlarmSettingFlag flag) NN_NOEXCEPT
{
    if (g_IsOverlayNotificationDisabled)
    {
        if (IsWatcherAvailable())
        {
            g_pWatcher->GetNetworkManager().SetNotifyNecessaryFlagForAlarmSettingChanged(flag);
        }
        return nn::ResultSuccess();
    }
    return NotifyAlarmSettingChangedImpl(flag);
}

}}}}}
