﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/overlay/pctl_OverlaySender.h>

#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace overlay {

namespace
{
    nn::ovln::SenderForOverlayType s_SenderSettingChanged;
    nn::ovln::SenderForOverlayType s_SenderRemainingTime;
    nn::ovln::SenderForOverlayType s_SenderUnlink;
    nn::ovln::SenderForOverlayType s_SenderTimeExceededOnStart;
    nn::ovln::SenderForOverlayType s_SenderAlarmSettingChanged;

    nn::Result NotifyImpl(nn::ovln::SenderForOverlayType* pSender, uint32_t tag, const void* data, size_t size) NN_NOEXCEPT
    {
        nn::ovln::Message message = {};
        message.tag = tag;
        message.dataSize = size;
        std::memcpy(&message.data, data, size);

        NN_RESULT_THROW_UNLESS(nn::ovln::Send(pSender, message),
            nn::pctl::ResultInvalidOperation());

        NN_RESULT_SUCCESS;
    }
    template <typename T>
    inline nn::Result NotifyImpl(nn::ovln::SenderForOverlayType* pSender, uint32_t tag, const T* data) NN_NOEXCEPT
    {
        return NotifyImpl(pSender, tag, data, sizeof(T));
    }
}

nn::Result InitializeOverlaySender() NN_NOEXCEPT
{
    NN_RESULT_DO(nn::ovln::InitializeSenderLibraryForOverlay());
    NN_RESULT_DO(nn::ovln::InitializeSenderForValue(&s_SenderSettingChanged));
    NN_RESULT_DO(nn::ovln::InitializeSenderForValue(&s_SenderRemainingTime));
    NN_RESULT_DO(nn::ovln::InitializeSenderForValue(&s_SenderUnlink));
    NN_RESULT_DO(nn::ovln::InitializeSenderForValue(&s_SenderTimeExceededOnStart));
    NN_RESULT_DO(nn::ovln::InitializeSenderForValue(&s_SenderAlarmSettingChanged));

    NN_RESULT_SUCCESS;
}

void FinalizeOverlaySender() NN_NOEXCEPT
{
    nn::ovln::FinalizeSender(&s_SenderAlarmSettingChanged);
    nn::ovln::FinalizeSender(&s_SenderTimeExceededOnStart);
    nn::ovln::FinalizeSender(&s_SenderUnlink);
    nn::ovln::FinalizeSender(&s_SenderRemainingTime);
    nn::ovln::FinalizeSender(&s_SenderSettingChanged);
    nn::ovln::FinalizeSenderLibraryForOverlay();
}

nn::Result NotifySettingChangedImpl(nn::ovln::format::PctlSettingTypeFlagSet settingType) NN_NOEXCEPT
{
    nn::ovln::format::PctlSettingChangedMessageData messageData = { settingType };
    return NotifyImpl(&s_SenderSettingChanged, nn::ovln::format::PctlSettingChangedMessage, &messageData);
}

nn::Result NotifyPlayTimerRemainingTimeImpl(int16_t remainingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT
{
    nn::ovln::format::PctlRemainingTimeMessageData messageData = { remainingTime, mode };
    return NotifyImpl(&s_SenderRemainingTime, nn::ovln::format::PctlRemainingTimeMessage, &messageData);
}

nn::Result NotifyUnlinkImpl(nn::ovln::format::PctlUnlinkReasonFlag reason) NN_NOEXCEPT
{
    nn::ovln::format::PctlUnlinkMessageData messageData = { reason };
    return NotifyImpl(&s_SenderUnlink, nn::ovln::format::PctlUnlinkMessage, &messageData);
}

nn::Result NotifyTimeExceededOnStartImpl(int64_t exceedingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT
{
    nn::ovln::format::PctlTimeExceededOnStartMessageData messageData = { exceedingTime, mode };
    return NotifyImpl(&s_SenderTimeExceededOnStart, nn::ovln::format::PctlTimeExceededOnStartMessage, &messageData);
}

nn::Result NotifyAlarmSettingChangedImpl(nn::ovln::format::PctlAlarmSettingFlag flag) NN_NOEXCEPT
{
    nn::ovln::format::PctlAlarmSettingChangedMessageData messageData = { flag };
    return NotifyImpl(&s_SenderAlarmSettingChanged, nn::ovln::format::PctlAlarmSettingChangedMessage, &messageData);
}

}}}}}
